/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.TopologyException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FilterVisitorFilterWrapper;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;

class FastBBOX
implements BBOX,
BinarySpatialOperator,
BinaryComparisonOperator,
GeometryFilter {
    String property;
    Envelope envelope;
    FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);

    public FastBBOX(String propertyName, Envelope env) {
        this.property = propertyName;
        this.envelope = env;
    }

    public double getMaxX() {
        return this.envelope.getMaxX();
    }

    public double getMaxY() {
        return this.envelope.getMaxY();
    }

    public double getMinX() {
        return this.envelope.getMinX();
    }

    public double getMinY() {
        return this.envelope.getMinY();
    }

    public String getPropertyName() {
        return this.property;
    }

    public String getSRS() {
        return null;
    }

    public Expression getExpression1() {
        return CommonFactoryFinder.getFilterFactory(null).property(this.property);
    }

    public Expression getExpression2() {
        Coordinate[] coords = new Coordinate[]{new Coordinate(this.envelope.getMinX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMinY())};
        LinearRing ring = null;
        GeometryFactory gfac = new GeometryFactory();
        try {
            ring = gfac.createLinearRing(coords);
        }
        catch (TopologyException tex) {
            throw new IllegalFilterException(tex.toString());
        }
        Polygon polygon = gfac.createPolygon(ring, null);
        if (this.envelope instanceof ReferencedEnvelope) {
            ReferencedEnvelope refEnv = (ReferencedEnvelope)this.envelope;
            polygon.setUserData((Object)refEnv.getCoordinateReferenceSystem());
        }
        return CommonFactoryFinder.getFilterFactory(null).literal((Object)polygon);
    }

    public Object accept(org.opengis.filter.FilterVisitor visitor, Object context) {
        Object result = visitor.visit((BBOX)this, context);
        if (!(result instanceof BBOX)) {
            return result;
        }
        BBOX clone = (BBOX)result;
        if (clone.getExpression1().equals(this.getExpression1()) && clone.getExpression2().equals(this.getExpression2())) {
            return new FastBBOX(this.property, this.envelope);
        }
        return result;
    }

    public boolean evaluate(Object feature) {
        SimpleFeature sf = (SimpleFeature)feature;
        if (feature == null) {
            return false;
        }
        Geometry other = (Geometry)sf.getAttribute(this.property);
        if (other == null) {
            return false;
        }
        return other.getEnvelopeInternal().intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public void addLeftGeometry(org.geotools.filter.Expression leftGeometry) throws IllegalFilterException {
        throw new UnsupportedOperationException("This filter cannot be modified");
    }

    public void addRightGeometry(org.geotools.filter.Expression rightGeometry) throws IllegalFilterException {
        throw new UnsupportedOperationException("This filter cannot be modified");
    }

    public boolean contains(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public org.geotools.filter.Expression getLeftGeometry() {
        return (org.geotools.filter.Expression)this.getExpression1();
    }

    public org.geotools.filter.Expression getRightGeometry() {
        return (org.geotools.filter.Expression)this.getExpression2();
    }

    public void accept(FilterVisitor visitor) {
        this.accept((org.opengis.filter.FilterVisitor)new FilterVisitorFilterWrapper(visitor), null);
    }

    public org.geotools.filter.Filter and(Filter filter) {
        return (org.geotools.filter.Filter)this.factory.and((Filter)this, filter);
    }

    public org.geotools.filter.Filter or(Filter filter) {
        return (org.geotools.filter.Filter)this.factory.or((Filter)this, filter);
    }

    public org.geotools.filter.Filter not() {
        return (org.geotools.filter.Filter)this.factory.not((Filter)this);
    }

    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public short getFilterType() {
        return 4;
    }
}

