/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.AttributeImpl;
import org.geotools.feature.ComplexAttributeImpl;
import org.geotools.feature.FeatureImpl;
import org.geotools.feature.NameImpl;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.FeatureTypeImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.geotools.gml3.GMLSchema;
import org.geotools.xs.XSSchema;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.identity.FeatureId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleDataAccessData {
    public static final String NAMESPACE_PREFIX = "gsml";
    public static final String NAMESPACE_URI = "http://www.example.org/sample-data-access/GeoSciML-lite";
    public static final Name GEOLOGICUNIT_TYPE_NAME = new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "GeologicUnit");
    public static final FeatureType GEOLOGICUNIT_TYPE = new FeatureTypeImpl(GEOLOGICUNIT_TYPE_NAME, Collections.emptyList(), null, false, Collections.emptyList(), (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);
    public static final AttributeDescriptor SPECIFICATION_DESCRIPTOR = new AttributeDescriptorImpl((AttributeType)GMLSchema.FEATUREPROPERTYTYPE_TYPE, (Name)new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "specification"), 0, 1, false, null);
    public static final AttributeDescriptor SHAPE_DESCRIPTOR = new AttributeDescriptorImpl(GMLSchema.GEOMETRYPROPERTYTYPE_TYPE, (Name)new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "shape"), 1, 1, false, null);
    private static final List<PropertyDescriptor> MAPPEDFEATURE_TYPE_SCHEMA = new ArrayList<PropertyDescriptor>(){
        {
            this.add(SPECIFICATION_DESCRIPTOR);
            this.add(SHAPE_DESCRIPTOR);
        }
    };
    public static final Name MAPPEDFEATURE_TYPE_NAME = new NameImpl("http://www.example.org/sample-data-access/GeoSciML-lite", "MappedFeature");
    public static final FeatureType MAPPEDFEATURE_TYPE = new FeatureTypeImpl(MAPPEDFEATURE_TYPE_NAME, MAPPEDFEATURE_TYPE_SCHEMA, null, false, Collections.emptyList(), (AttributeType)GMLSchema.ABSTRACTFEATURETYPE_TYPE, null);

    public static Feature createMappedFeature(String id, String bgsid, String description, String specificationDescription, Geometry shape) {
        ArrayList<Property> specificationFeatureProperties = new ArrayList<Property>(specificationDescription){
            {
                this.add(new AttributeImpl((Object)string, (AttributeDescriptor)new AttributeDescriptorImpl(XSSchema.STRING_TYPE, (Name)new NameImpl("http://www.opengis.net/gml", "description"), 0, 1, false, null), null));
            }
        };
        FeatureImpl specificationFeature = new FeatureImpl((Collection)specificationFeatureProperties, GEOLOGICUNIT_TYPE, (FeatureId)new FeatureIdImpl(String.valueOf(id) + ".spec"));
        ArrayList<Property> properties = new ArrayList<Property>(description, shape, (Feature)specificationFeature){
            {
                this.add(new AttributeImpl((Object)string, (AttributeDescriptor)new AttributeDescriptorImpl(XSSchema.STRING_TYPE, (Name)new NameImpl("http://www.opengis.net/gml", "description"), 0, 1, false, null), null));
                this.add(new ComplexAttributeImpl((Collection)new ArrayList<Property>(feature){
                    {
                        this.add(feature);
                    }
                }, SPECIFICATION_DESCRIPTOR, null));
                this.add(new AttributeImpl((Object)geometry, SHAPE_DESCRIPTOR, null));
            }
        };
        return new FeatureImpl((Collection)properties, MAPPEDFEATURE_TYPE, (FeatureId)new FeatureIdImpl(id));
    }

    public static List<Feature> createMappedFeatures() {
        return new ArrayList<Feature>(){
            {
                this.add(SampleDataAccessData.createMappedFeature("mf1", "651", "GUNTHORPE FORMATION", "Gunthorpe specification description", SampleDataAccessData.readGeometry("POLYGON((-1.2 52.5,-1.2 52.6,-1.1 52.6,-1.1 52.5,-1.2 52.5))")));
                this.add(SampleDataAccessData.createMappedFeature("mf2", "269", "MERCIA MUDSTONE GROUP", "Mercia specification description", SampleDataAccessData.readGeometry("POLYGON((-1.3 52.5,-1.3 52.6,-1.2 52.6,-1.2 52.5,-1.3 52.5))")));
            }
        };
    }

    public static Geometry readGeometry(String wellKnownText) {
        try {
            return new WKTReader().read(wellKnownText);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

