/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.wms;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMSChooser {
    public static URL showChooseWMS() {
        return WMSChooser.showChooseWMS(WMSChooser.deafultServers());
    }

    public static URL showChooseWMS(List<String> servers) {
        if (servers == null) {
            servers = WMSChooser.deafultServers();
        }
        JComboBox<Object> combo = new JComboBox<Object>(servers.toArray());
        combo.setEditable(true);
        Object[] message = new Object[]{"Choose a WMS Server", combo};
        int done;
        while ((done = JOptionPane.showConfirmDialog(null, message, "Web Map Server", 2, 3)) != 2) {
            Object input = combo.getSelectedItem();
            try {
                return new URL((String)input);
            }
            catch (Throwable t) {
                message = new Object[]{"Choose a WMS Service", combo, t.getMessage()};
                continue;
            }
            break;
        }
        return null;
    }

    private static List<String> deafultServers() {
        ArrayList<String> servers = new ArrayList<String>();
        servers.add("http://wms.jpl.nasa.gov/wms.cgi?Service=WMS&Version=1.1.1&Request=GetCapabilities");
        servers.add("http://localhost:8080/geoserver/wms?service=WMS&request=GetCapabilities");
        servers.add("http://www2.dmsolutions.ca/cgi-bin/mswms_gmap?Service=WMS&VERSION=1.1.0&REQUEST=GetCapabilities");
        servers.add("http://giswebservices.massgis.state.ma.us/geoserver/wms?service=WMS&request=GetCapabilities");
        servers.add("http://wms.cits.rncan.gc.ca/cgi-bin/cubeserv.cgi?VERSION=1.1.0&REQUEST=GetCapabilities");
        servers.add("http://atlas.gc.ca/cgi-bin/atlaswms_en?VERSION=1.1.1&Request=GetCapabilities&Service=WMS");
        return servers;
    }
}

