/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.swing.data;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.geotools.data.Parameter;
import org.geotools.swing.wizard.JPage;
import org.geotools.swing.wizard.ParamField;
import org.geotools.util.Converters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JParameterListPage
extends JPage {
    String title;
    String description;
    List<Parameter<?>> contents;
    private Map<Parameter<?>, ParamField> fields = new HashMap();
    protected Map<String, Object> connectionParameters;

    public JParameterListPage(String title, String description, List<Parameter<?>> contents, Map<String, Object> params) {
        this.title = title;
        this.description = description;
        this.contents = contents;
        this.connectionParameters = params;
    }

    @Override
    public JPanel createPanel() {
        JPanel page = super.createPanel();
        page.setLayout((LayoutManager)new MigLayout());
        JLabel title = new JLabel(this.title);
        Font titleFont = new Font("Arial", 1, 14);
        title.setFont(titleFont);
        page.add((Component)title, "span");
        if (this.description != null) {
            JLabel description = new JLabel(this.description);
            page.add((Component)description, "grow, span");
        }
        for (Parameter<?> param : this.contents) {
            String txt = param.title.toString();
            if (param.required) {
                txt = txt + "*";
            }
            JLabel label = new JLabel(txt);
            page.add(label);
            ParamField field = ParamField.create(param);
            JComponent component = field.doLayout();
            page.add((Component)component, "span, wrap");
            this.fields.put(param, field);
            if (param.description == null) continue;
            JLabel info = new JLabel("<html>" + param.description.toString());
            page.add((Component)info, "skip, span, wrap");
        }
        return page;
    }

    @Override
    public void preDisplayPanel() {
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            Parameter<?> param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = null;
            Object object = this.connectionParameters.get(param.key);
            value = Converters.convert((Object)object, (Class)param.type);
            if (value == null) {
                value = object;
            }
            if (value == null && param.required) {
                value = param.sample;
            }
            field.setValue(value);
        }
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            ParamField field = entry.getValue();
            field.addListener(this.getJWizard().getController());
        }
    }

    @Override
    public void preClosePanel() {
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            Parameter<?> param = entry.getKey();
            ParamField field = entry.getValue();
            Object value = field.getValue();
            this.connectionParameters.put(param.key, value);
        }
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            ParamField field = entry.getValue();
            field.removeListener(this.getJWizard().getController());
        }
    }

    @Override
    public boolean isValid() {
        for (Map.Entry<Parameter<?>, ParamField> entry : this.fields.entrySet()) {
            Parameter<?> param = entry.getKey();
            ParamField field = entry.getValue();
            if (!field.validate()) {
                return false;
            }
            if (!param.required || field.getValue() != null) continue;
            return false;
        }
        return true;
    }
}

