/*
 * Decompiled with CFR 0.152.
 */
package org.tecgraf.tdk.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.tools.ant.util.FileUtils;
import org.junit.Assert;

public class CommonTestDataRetriever {
    private static final String SHAPEFILE_DIRECTORY = "shapefiles";
    private static final String SHAPEFILE_MAIN_EXTENSION = ".shp";
    private static final String[] SHAPEFILE_EXTENSIONS = new String[]{".dbf", ".fix", ".prj", ".qix", ".shx", ".shp"};
    private static final String TERRALIB_DIRECTORY = "terralib";
    private static final String TERRALIB_MAIN_EXTENSION = ".mdb";

    protected static void copyFile(String sourcePath, String sourceFileName, String targetPath) {
        String testPath = targetPath + File.separator + sourceFileName;
        try {
            File workingDatabaseFile = new File(testPath);
            if (workingDatabaseFile.exists() && !workingDatabaseFile.delete()) {
                throw new IOException("Failed to remove test database. (file: " + workingDatabaseFile.getAbsolutePath() + ")");
            }
            FileUtils.getFileUtils().copyFile(sourcePath + File.separator + sourceFileName, testPath);
        }
        catch (IOException e) {
            e.printStackTrace();
            Assert.fail((String)"Error restoring egypt access database.");
        }
    }

    public static enum TerralibAccess {
        EGYPT("egypt_terrabase");

        private String _filePath;

        private TerralibAccess(String dbName) {
            this._filePath = "/terralib/" + dbName + CommonTestDataRetriever.TERRALIB_MAIN_EXTENSION;
        }

        public URL getURL() {
            return CommonTestDataRetriever.class.getResource(this._filePath);
        }

        public String getPath() throws IOException {
            File file;
            try {
                file = new File(this.getURL().toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            return file.getAbsolutePath();
        }
    }

    public static enum ShapeFileResources {
        COUNTRIES("countries");

        private String _shapeName;
        private String _filePath;

        private ShapeFileResources(String shapeName) {
            this._shapeName = shapeName;
            this._filePath = "/shapefiles/" + this._shapeName + CommonTestDataRetriever.SHAPEFILE_MAIN_EXTENSION;
        }

        public URL getURL() {
            return CommonTestDataRetriever.class.getResource(this._filePath);
        }

        public String getPath() throws IOException {
            File file;
            try {
                file = new File(this.getURL().toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            return file.getAbsolutePath();
        }

        protected URL getDirectoryURL() {
            return CommonTestDataRetriever.class.getResource("/shapefiles");
        }

        public URL getTestShapeURL(String targetPath) throws IOException {
            File file;
            try {
                file = new File(this.getDirectoryURL().toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            String sourcePath = file.getAbsolutePath();
            for (String extension : SHAPEFILE_EXTENSIONS) {
                CommonTestDataRetriever.copyFile(sourcePath, this._shapeName + extension, targetPath);
            }
            File tempFile = new File(targetPath + this._shapeName + CommonTestDataRetriever.SHAPEFILE_MAIN_EXTENSION);
            return tempFile.toURI().toURL();
        }

        public void copyToTestDirectory(String targetPath) {
            CommonTestDataRetriever.copyFile(".\\src\\test\\resources\\", this._shapeName + CommonTestDataRetriever.SHAPEFILE_MAIN_EXTENSION, targetPath);
        }
    }
}

