/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: DBConnectionCachingUtils.java
 * created: Dec 18, 2009
 */
package org.tecgraf.tdk.data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

import static org.geotools.data.terralib.connection.DBConnectionParamUtils.DBPATH;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.DBDRIVER;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.DATABASE_DRIVER_ACCESS;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.HOST;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.DBNAME;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.PORT;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.USER;
import static org.geotools.data.terralib.connection.DBConnectionParamUtils.PASSWD;
import static org.tecgraf.tdk.data.AbstractDataStoreFactoryDecorator.CACHE_TYPE;
import org.tecgraf.tdk.data.CachingType;
import org.geotools.data.DataAccessFactory.Param;


/**
 * This is an utility class used to support the creating of parameter maps with the TerralibDataStore
 * with cache.
 * @author fabiomano
 * @since gt-terralib-datastore 1.0
 */
public class DBConnectionTerralibCachingUtils
{
    public static final String TERRALIB_CACHED_DATABASE_TYPE = "terralib-cached";
    
    public static final Param CACHING_TE_TYPE = new Param("cachingdbtype", String.class,"must be 'terralib-caching'", true, TERRALIB_CACHED_DATABASE_TYPE);

    public static Map<String,Serializable> createAccessParametersMap(CachingType cachingType, String path)
    {
        Map<String, Serializable> parameterMap = new HashMap<String, Serializable>();

        parameterMap.put(DBDRIVER.key, DATABASE_DRIVER_ACCESS);
        parameterMap.put(DBPATH.key, path);
        parameterMap.put(CACHE_TYPE.key, cachingType);
        parameterMap.put(CACHING_TE_TYPE.key, TERRALIB_CACHED_DATABASE_TYPE);

        return parameterMap;
    }    
    
    public static Map<String, Serializable> createParametersMap(CachingType cachingType, String dataBaseDriver, String host, Integer portNumber, String dataBaseName, String userName, String password)
    {
        Map<String, Serializable> parameterMap = new HashMap<String, Serializable>();

        parameterMap.put(DBDRIVER.key, dataBaseDriver);
        parameterMap.put(HOST.key, host);
        parameterMap.put(DBNAME.key, dataBaseName);
        parameterMap.put(PORT.key, portNumber);
        parameterMap.put(USER.key, userName);
        parameterMap.put(PASSWD.key, password);
        
        parameterMap.put(CACHE_TYPE.key, cachingType);
        parameterMap.put(CACHING_TE_TYPE.key, TERRALIB_CACHED_DATABASE_TYPE);

        return parameterMap;
    }    
    
}
