/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: TerralibFeatureType.java
 * created: 09/01/2009
 */
package org.geotools.data.terralib;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Map.Entry;

import org.geotools.data.terralib.exception.AttributeNameColisionException;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

/**
 * FIXDOC
 * @author fmoura
 * @since TDK 3.0.0
 */
public class TerralibFeatureType extends SimpleFeatureTypeImpl
{
   // private Set<String> _attributeTablesNames;
    private Map<String,String> _attibuteNameToTableMap;

    /**
     * FIXDOC
     * @param name
     * @param schema
     * @param defaultGeometry
     * @param isAbstract
     * @param restrictions
     * @param superType
     * @param description
     * @throws AttributeNameColisionException 
     * @since TDK 3.0.0
     */
    public TerralibFeatureType(Name name, Map<String,List<AttributeDescriptor>> schema,
            GeometryDescriptor defaultGeometry, boolean isAbstract,
            List<Filter> restrictions, AttributeType superType,
            InternationalString description) throws AttributeNameColisionException
    {
        super(name, extractAttributeList(schema), defaultGeometry, isAbstract, restrictions, superType,
                description);
        
        _attibuteNameToTableMap = createAttributeNameToTableMap(schema);
    }

    /**
     * FIXDOC
     * @param schema
     * @return
     * @throws AttributeNameColisionException 
     * @since
     */
    private Map<String, String> createAttributeNameToTableMap(
            Map<String, List<AttributeDescriptor>> schema) throws AttributeNameColisionException
    {
        Map<String,String> attributeNameToTableMap = new HashMap<String, String>();
        
        
        if(schema == null)
        {
            return attributeNameToTableMap;
        }
        
        for(Entry<String,List<AttributeDescriptor>> entry : schema.entrySet())
        {
            for(AttributeDescriptor attributeDescriptor : entry.getValue())
            {
                if(attributeNameToTableMap.containsKey(attributeDescriptor.getLocalName()))
                {
                    throw new AttributeNameColisionException(attributeDescriptor.getLocalName(),entry.getKey(),attributeNameToTableMap.get(attributeDescriptor.getLocalName()));
                }
                
                attributeNameToTableMap.put(attributeDescriptor.getLocalName(), entry.getKey());
            }
        }
        
        return attributeNameToTableMap;
    }

    /**
     * Extracts the attributes list and puts the geometry attribute as the first attribute.
     * @param schema
     * @return
     * @since TDK 3.0.0
     */
    private static List<AttributeDescriptor> extractAttributeList(
            Map<String, List<AttributeDescriptor>> schema)
    {
        if(schema == null)
        {
            return null;
        }
        
        List<AttributeDescriptor> fullAttributeList = new ArrayList<AttributeDescriptor>();
        
        List<String> tableNames = new ArrayList<String>();
        tableNames.addAll(schema.keySet());
        Collections.sort(tableNames);

        for (String tableName : tableNames)
        {
            if (!tableName.equals(DefaultTerralibService.getDEFAULT_GEOMETRY_TABLE_NAME()))
        		fullAttributeList.addAll(schema.get(tableName));
            else
                fullAttributeList.addAll(0, schema.get(tableName));
        }
        
        return fullAttributeList;
    }
    
    /**
     * FIXDOC
     * @return
     * @since TDK 3.0.0
     */
    public Set<String> getAttributeTablesNames()
    {
        Set<String> tableNames = new HashSet<String>();
        for(String tableName : _attibuteNameToTableMap.values())
        {
            tableNames.add(tableName);
        }
        return tableNames;
    }
    
    public String getAttributeTableName(String attributeName)
    {
        return _attibuteNameToTableMap.get(attributeName);
    }
    
    /* (non-Javadoc)
         * @see org.geotools.feature.type.FeatureTypeImpl#equals(java.lang.Object)
         */
    @Override
    public boolean equals(Object object)
    {
        boolean result = super.equals(object);
        
        if(result == false) return false;
        
        if(object instanceof TerralibFeatureType)
        {
            TerralibFeatureType other = (TerralibFeatureType) object;
            
            List<AttributeDescriptor> attributes = other.getAttributeDescriptors();
            for(AttributeDescriptor attributeDescriptor : attributes)
            {
                if(!_attibuteNameToTableMap.containsKey(attributeDescriptor.getLocalName()))return false;
                if(!other.getAttributeTableName(attributeDescriptor.getLocalName()).equals(_attibuteNameToTableMap.get(attributeDescriptor.getLocalName()))) return false;
            }
            
            return true;
        }
        
        return false;   
    }
    
    /* (non-Javadoc)
         * @see org.geotools.feature.type.FeatureTypeImpl#hashCode()
         */
        @Override
        public int hashCode()
        {
            int hashCode  = super.hashCode();
            hashCode += _attibuteNameToTableMap.hashCode();
            return hashCode;
        } 
    
    
}
