/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: GeometryFactory.java
 * created: 19/03/2009
 */
package org.geotools.data.terralib.geometry;

import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;

/**
 * @author fmoura
 *
 */
public class GeometryBuilder
{
    static GeometryFactory _defaultGeometryFactory = new GeometryFactory(new LiteCoordinateSequenceFactory());
    static LiteCoordinateSequenceFactory _sequenceFactory = new LiteCoordinateSequenceFactory();
    //factory.
//    LineString buildLineString(double[] coords)
//    {
//        GeometryFactory factory = new GeometryFactory();
//        factory.
//    }
    
    
    static double[] getPolygonExternalRing(Polygon polygon)
    {
        LineString lineString = polygon.getExteriorRing();
        return getLineVertices(lineString);
    }

/**
 * @param lineString
 * @return
 * @since
 */
    static public double[] getLineVertices(LineString lineString)
    {
        Coordinate[] coordinates = lineString.getCoordinates(); 
        double[] vertices = new double[coordinates.length*2];
        
        Coordinate currentCoord;
        int index = 0;
        for(int i = 0; i < coordinates.length; i++)
        {            
            currentCoord = coordinates[i]; 
            vertices[index] = currentCoord.x;
            vertices[index+1] = currentCoord.y;
            index = index + 2;
        }
        
        return vertices;
    }
    
    static public LineString buildLineString(double[] vertices)
    {
        
        Coordinate[] coordinates = new Coordinate[vertices.length/2];
        
        int index = 0;
        for(int i = 0 ; i < coordinates.length; i++)
        {
            Coordinate coord = new Coordinate(vertices[index],vertices[index+1]);
            coordinates[i] = coord;
            index = index + 2;
        }
        
        return _defaultGeometryFactory.createLineString(coordinates );
    }
    
    static public LinearRing buildLinearRing(double[] vertices)
    {
        //int numCoodinates = vertices.length/2;
        //Coordinate[] coordinates = new Coordinate[numCoodinates+1];
        
        //int index = 0;
        
        CoordinateSequence coordinateSequence = _sequenceFactory.create(vertices);//new PackedCoordinateSequence.Double(vertices,2);
//        for(int i = 0 ; i < numCoodinates; i++)
//        {
//            Coordinate coord = new Coordinate(vertices[index],vertices[index+1]);
//            coordinates[i] = coord;
//            index = index + 2;
//        }
        //coordinates[numCoodinates] = coordinates[0];
        
        return _defaultGeometryFactory.createLinearRing(coordinateSequence);
    }
    
//    static public Polygon buildPolygon(double[] vertices, int[] indexes)
//    {
//        
//    }

}
