/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: InvalidLayerNameException.java
 * created: Apr 23, 2009
 */
package org.geotools.data.terralib.persistence.exception;


/**
 * Happens at the terralib database when a layer name has ":" character.
 * It's not allowed, because : is used to identify themes. A theme name is 
 * it's view_id : theme_name (to allow 2 themes at different views with the 
 * same name). 
 * @author fabiomano
 * @since TDK3.0.0
 */
public class InvalidLayerNameException extends PersistenceRuntimeException
{
    private static final long serialVersionUID = 2123092391649229585L;


    /**
     * @param message
     */
    public InvalidLayerNameException(String message)
    {
        super(message);
    }


    /**
     * @param message
     * @param cause
     */
    public InvalidLayerNameException(String message, Throwable cause)
    {
        super(message, cause);
    }
}
