/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: TypeAttributeMap.java
 * created: 05/05/2009
 */
package org.geotools.data.terralib.util;

import java.util.Date;

import org.geotools.data.terralib.swig.TeAttrDataType;
import org.geotools.data.terralib.swig.TeGeomRep;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;

/**
 * Controls the mapping and conversion between TerraLib Attribute 
 * data type, Terralib Geometry rep and GeoTools AttributeType. 
 * @author fabiomano
 * @since TDK3.0.0
 */
public enum TypeAttributeMap 
{
	TA_INTEGER(TeAttrDataType.TeINT,Integer.class,null)
	,TA_LONG(TeAttrDataType.TeINT,Long.class,null)	//we will translate long to int, terralib does not support long
	,TA_REAL(TeAttrDataType.TeREAL,Double.class,null)
	,TA_STRING(TeAttrDataType.TeSTRING,String.class,null)
	,TA_DATE(TeAttrDataType.TeDATETIME,Date.class,null)
	,TA_MULTIPOINT(TeAttrDataType.TePOINTTYPE,MultiPoint.class, TeGeomRep.TePOINTS)
	,TA_MULTIPOLYGON(TeAttrDataType.TePOLYGONTYPE,MultiPolygon.class, TeGeomRep.TePOLYGONS)
	,TA_LINES(TeAttrDataType.TeLINE2DTYPE,MultiLineString.class, TeGeomRep.TeLINES)
	;
	
	private TeAttrDataType _terralibAttr;
	private Class<?> _bindingClass;
	private TeGeomRep _geoRep;
	
	private TypeAttributeMap(TeAttrDataType terralibAttr, Class<?> bindingClass, TeGeomRep geoRep)
	{
		_terralibAttr = terralibAttr;
		_bindingClass = bindingClass;
		_geoRep = geoRep;
	}
	
	public Class<?> getBindingClass()
	{
		return _bindingClass;
	}
	
	public TeAttrDataType getTeAttributeType()
	{
		return _terralibAttr;
	}
	
	public TeGeomRep getGeomRep()
	{
		return _geoRep;
	}
	
	public boolean isGeometry()
	{
		return (_geoRep != null);
	}
	
	public static TypeAttributeMap fromTeGeomRep(TeGeomRep geom)
	{
		for (int i=0; i< TypeAttributeMap.values().length; i++)
		{
			if (TypeAttributeMap.values()[i]._geoRep == geom)
				return TypeAttributeMap.values()[i];
		}
		return null;
	}
	
	public static TypeAttributeMap fromBindingClass(Class<?> binding)
	{
		for (int i=0; i< TypeAttributeMap.values().length; i++)
		{
			if (TypeAttributeMap.values()[i]._bindingClass.isAssignableFrom(binding))
				return TypeAttributeMap.values()[i];
		}
		return null;
	}	
	
	public static TypeAttributeMap fromTeAttrDataType(TeAttrDataType attrDataType)
	{
		for (int i=0; i< TypeAttributeMap.values().length; i++)
		{
			if (TypeAttributeMap.values()[i]._terralibAttr == attrDataType)
				return TypeAttributeMap.values()[i];
		}
		return null;
	}	
	
	public static TypeAttributeMap fromGeometryType(GeometryType geomType)
	{
		return fromBindingClass(geomType.getBinding());
	}	
	
	public static TypeAttributeMap fromAttributeType(AttributeType attrType)
	{
		return fromBindingClass(attrType.getBinding());
	}	

	
//	public static TeAttrDataType translateAttribute(AttributeType attributeType)
//	{
//		final Class<?> bindingClass = attributeType.getBinding();
//		
//		for (int i=0; i< TypeAttributeMap.values().length; i++)
//		{
//			if (bindingClass == TypeAttributeMap.values()[i]._bindingClass)
//				return TypeAttributeMap.values()[i]._terralibAttr;
//		}
//		return null;
//	}
//	
//	public static AttributeType translateTerralibAttribute(TeAttrDataType teAttrType, AttributeTypeBuilder attributeTypeBuilder)
//	{
//		for (int i=0; i< TypeAttributeMap.values().length; i++)
//		{
//			TeAttrDataType teType = TypeAttributeMap.values()[i]._terralibAttr;
//			if (teType == teAttrType)
//			{
//		        attributeTypeBuilder.setBinding(TypeAttributeMap.values()[i]._bindingClass);
//		        AttributeType attributeType = attributeTypeBuilder.buildType();
//		        return attributeType;
//			}
//		}
//		return null;
//	}
	
}
