/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.terralib.DefaultTerralibService;
import org.geotools.data.terralib.exception.AttributeNameColisionException;
import org.geotools.feature.simple.SimpleFeatureTypeImpl;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public class TerralibFeatureType
extends SimpleFeatureTypeImpl {
    private Map<String, String> _attibuteNameToTableMap;

    public TerralibFeatureType(Name name, Map<String, List<AttributeDescriptor>> schema, GeometryDescriptor defaultGeometry, boolean isAbstract, List<Filter> restrictions, AttributeType superType, InternationalString description) throws AttributeNameColisionException {
        super(name, TerralibFeatureType.extractAttributeList(schema), defaultGeometry, isAbstract, restrictions, superType, description);
        this._attibuteNameToTableMap = this.createAttributeNameToTableMap(schema);
    }

    private Map<String, String> createAttributeNameToTableMap(Map<String, List<AttributeDescriptor>> schema) throws AttributeNameColisionException {
        HashMap<String, String> attributeNameToTableMap = new HashMap<String, String>();
        if (schema == null) {
            return attributeNameToTableMap;
        }
        for (Map.Entry<String, List<AttributeDescriptor>> entry : schema.entrySet()) {
            for (AttributeDescriptor attributeDescriptor : entry.getValue()) {
                if (attributeNameToTableMap.containsKey(attributeDescriptor.getLocalName())) {
                    throw new AttributeNameColisionException(attributeDescriptor.getLocalName(), entry.getKey(), (String)attributeNameToTableMap.get(attributeDescriptor.getLocalName()));
                }
                attributeNameToTableMap.put(attributeDescriptor.getLocalName(), entry.getKey());
            }
        }
        return attributeNameToTableMap;
    }

    private static List<AttributeDescriptor> extractAttributeList(Map<String, List<AttributeDescriptor>> schema) {
        if (schema == null) {
            return null;
        }
        ArrayList<AttributeDescriptor> fullAttributeList = new ArrayList<AttributeDescriptor>();
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.addAll(schema.keySet());
        Collections.sort(tableNames);
        for (String tableName : tableNames) {
            if (!tableName.equals(DefaultTerralibService.getDEFAULT_GEOMETRY_TABLE_NAME())) {
                fullAttributeList.addAll((Collection<AttributeDescriptor>)schema.get(tableName));
                continue;
            }
            fullAttributeList.addAll(0, (Collection<AttributeDescriptor>)schema.get(tableName));
        }
        return fullAttributeList;
    }

    public Set<String> getAttributeTablesNames() {
        HashSet<String> tableNames = new HashSet<String>();
        for (String tableName : this._attibuteNameToTableMap.values()) {
            tableNames.add(tableName);
        }
        return tableNames;
    }

    public String getAttributeTableName(String attributeName) {
        return this._attibuteNameToTableMap.get(attributeName);
    }

    public boolean equals(Object object) {
        boolean result = super.equals(object);
        if (!result) {
            return false;
        }
        if (object instanceof TerralibFeatureType) {
            TerralibFeatureType other = (TerralibFeatureType)((Object)object);
            List attributes = other.getAttributeDescriptors();
            for (AttributeDescriptor attributeDescriptor : attributes) {
                if (!this._attibuteNameToTableMap.containsKey(attributeDescriptor.getLocalName())) {
                    return false;
                }
                if (other.getAttributeTableName(attributeDescriptor.getLocalName()).equals(this._attibuteNameToTableMap.get(attributeDescriptor.getLocalName()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        return hashCode += ((Object)this._attibuteNameToTableMap).hashCode();
    }
}

