/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.exception.IllegalStateException;
import org.geotools.data.terralib.exception.InvalidCrsWktException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.swig.DBConnection;
import org.geotools.data.terralib.swig.PersistenceTransferenceObject;
import org.geotools.data.terralib.swig.StringVector;
import org.geotools.data.terralib.swig.TeAttrDataType;
import org.geotools.data.terralib.swig.TeGeomRep;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptor;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptorVector;
import org.geotools.data.terralib.swig.TerralibServiceNative;
import org.geotools.data.terralib.util.thread.Watchdog;

public class ThreadBlockingTerralibService
extends TerralibServiceNative {
    private static final StackTraceElement[] EMPTY_STACK = new StackTraceElement[0];
    private static final long NO_THREAD = -1L;
    private static final int WATCHDOG_TIMEOUT_MILLISECONDS = 60000;
    private static final int WATCHDOG_CHECK_STEP_MILLISECONDS = 100;
    Logger _logger = Logger.getLogger(ThreadBlockingTerralibService.class);
    private Semaphore _semaphore = new Semaphore(1);
    private boolean _enableLock;
    private Watchdog _watchdog = new Watchdog(100L);
    private StackTraceElement[] _lastSuccessfullCallerStack = EMPTY_STACK;
    private long _lastSuccessfullThreadID = -1L;

    protected ThreadBlockingTerralibService(DBConnection connection, boolean enableLock) {
        super(connection);
        this._enableLock = enableLock;
        if (this._enableLock) {
            this._logger.info((Object)"Using locking mechanism.");
        } else {
            this._logger.info((Object)"NOT using locking mechanism.");
        }
        Timer timer = new Timer();
        timer.schedule((TimerTask)this._watchdog, 0L, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFeatureType(String typeName) throws IOException, TypeNotFoundException {
        String uuid = this.getLock();
        try {
            super.dropFeatureType(typeName);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TerralibAttributeDescriptor buildTerralibAttributeDescriptor(String name, boolean isNullable, boolean isPrimaryKey, int length, TeAttrDataType type) {
        String uuid = this.getLock();
        try {
            TerralibAttributeDescriptor terralibAttributeDescriptor = super.buildTerralibAttributeDescriptor(name, isNullable, isPrimaryKey, length, type);
            return terralibAttributeDescriptor;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createAttributeTable(String tableName, TerralibAttributeDescriptorVector attributes) throws IllegalStateException, IOException {
        String uuid = this.getLock();
        try {
            super.createAttributeTable(tableName, attributes);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createType(String typeName, TeGeomRep geomRep, String crsWkt) throws IOException, InvalidCrsWktException {
        String uuid = this.getLock();
        try {
            super.createType(typeName, geomRep, crsWkt);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        String uuid = this.getLock();
        try {
            super.dispose();
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropFeatureType(String typeName, boolean ignoreAttributes) throws TypeNotFoundException, IOException {
        String uuid = this.getLock();
        try {
            super.dropFeatureType(typeName, ignoreAttributes);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Envelope getBoundingBox(String typeName) throws IllegalStateException, TypeNotFoundException {
        String uuid = this.getLock();
        try {
            Envelope envelope = super.getBoundingBox(typeName);
            return envelope;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getGeometryCount(String typeName) throws TypeNotFoundException, IOException {
        String uuid = this.getLock();
        try {
            int n = super.getGeometryCount(typeName);
            return n;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getGeomRep(String typeName) throws IllegalStateException, TypeNotFoundException {
        String uuid = this.getLock();
        try {
            int n = super.getGeomRep(typeName);
            return n;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TerralibAttributeDescriptorVector getTypeAttributes(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        String uuid = this.getLock();
        try {
            TerralibAttributeDescriptorVector terralibAttributeDescriptorVector = super.getTypeAttributes(typeName);
            return terralibAttributeDescriptorVector;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getTypeProjectionWKT(String typeName) throws IllegalStateException, TypeNotFoundException {
        String uuid = this.getLock();
        try {
            String string = super.getTypeProjectionWKT(typeName);
            return string;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getTypesNames(StringVector out) throws IllegalStateException {
        String uuid = this.getLock();
        try {
            super.getTypesNames(out);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getViewIDs(StringVector out) {
        String uuid = this.getLock();
        try {
            super.getViewIDs(out);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getViewProjectionWKT(String viewID) throws TypeNotFoundException {
        String uuid = this.getLock();
        try {
            String string = super.getViewProjectionWKT(viewID);
            return string;
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void getViewTypesNames(String viewID, StringVector out) {
        String uuid = this.getLock();
        try {
            super.getViewTypesNames(viewID, out);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String insert(String typeName, PersistenceTransferenceObject transferObject, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        String string = super.insert(typeName, transferObject, ignoreAttributes);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String insert(String typeName, PersistenceTransferenceObject transferObject) throws IllegalStateException, TypeNotFoundException, IOException {
        String string = super.insert(typeName, transferObject);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void linkAttributeTable(String typeName, String tableName, String linkAttributeColumn) throws TypeNotFoundException, IllegalStateException, IOException {
        String uuid = this.getLock();
        try {
            super.linkAttributeTable(typeName, tableName, linkAttributeColumn);
        }
        finally {
            this.releaseLock(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String typeName, String featureId, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        super.remove(typeName, featureId, ignoreAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(String typeName, String featureId) throws IllegalStateException, TypeNotFoundException, IOException {
        super.remove(typeName, featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFeatures(String typeName, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        super.removeAllFeatures(typeName, ignoreAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String typeName, PersistenceTransferenceObject transferObject, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        super.update(typeName, transferObject, ignoreAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(String typeName, PersistenceTransferenceObject transferObject) throws IllegalStateException, TypeNotFoundException, IOException {
        super.update(typeName, transferObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLock() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String uuid = null;
        long threadID = Thread.currentThread().getId();
        if (this._enableLock) {
            ThreadBlockingTerralibService threadBlockingTerralibService = this;
            synchronized (threadBlockingTerralibService) {
                if (this._semaphore.availablePermits() == 0) {
                    uuid = UUID.randomUUID().toString();
                    this._watchdog.add(uuid, threadID, stackTrace, this._lastSuccessfullThreadID, this._lastSuccessfullCallerStack, 60000L);
                }
            }
            this._semaphore.acquireUninterruptibly();
            threadBlockingTerralibService = this;
            synchronized (threadBlockingTerralibService) {
                this._lastSuccessfullCallerStack = stackTrace;
                this._lastSuccessfullThreadID = threadID;
            }
        }
        return uuid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(String uuid) {
        if (this._enableLock) {
            this._semaphore.release();
            ThreadBlockingTerralibService threadBlockingTerralibService = this;
            synchronized (threadBlockingTerralibService) {
                this._lastSuccessfullCallerStack = EMPTY_STACK;
                this._lastSuccessfullThreadID = -1L;
            }
            this._watchdog.remove(uuid);
        }
    }
}

