/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.query;

import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.FeatureTypeInfo;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TerralibProviderRuntimeException;
import org.geotools.data.terralib.query.QueryData;
import org.geotools.data.terralib.swig.DatabasePortal;
import org.geotools.data.terralib.swig.PersistenceTransferenceObject;
import org.geotools.data.terralib.swig.TerralibServiceNative;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class TerralibQueryData
implements QueryData {
    private static final Logger _logger = Logger.getLogger(TerralibQueryData.class);
    private static final int NO_GEOMETRY_FIELD_FOUND = -1;
    private WriteMode _currentWriteMode = WriteMode.UPDATE;
    private TerralibService _terralibService;
    private DatabasePortal _databasePortal;
    private List<AttributeDescriptor> _attributeDescriptors;
    private FeatureTypeInfo _featureTypeInfo;
    private int _numFields = 0;
    private Object[] _currentFieldsValues = null;
    private Object[] _writeBuffer = null;
    private int _geometryAttributeIndex = -1;
    private boolean _closed = false;
    private String _lockUUID;

    protected TerralibQueryData(TerralibService terralibService, DatabasePortal portal, FeatureTypeInfo featureTypeInfo) throws IOException {
        this(terralibService, portal, featureTypeInfo, null);
    }

    protected TerralibQueryData(TerralibService terralibService, DatabasePortal portal, FeatureTypeInfo featureTypeInfo, String lockUUID) throws IOException {
        if (terralibService == null) {
            throw new NullArgumentException("terralibService");
        }
        if (portal == null) {
            throw new NullArgumentException("portal");
        }
        if (featureTypeInfo == null) {
            throw new NullArgumentException("featureTypeInfo");
        }
        this._lockUUID = lockUUID;
        this._terralibService = terralibService;
        this._databasePortal = portal;
        this._attributeDescriptors = featureTypeInfo.getTypeAttributeList();
        this._numFields = featureTypeInfo.getTypeAttributeList().size();
        for (int i = 0; i < this._numFields; ++i) {
            if (!(this._attributeDescriptors.get(i) instanceof GeometryDescriptor)) continue;
            this._geometryAttributeIndex = i;
            break;
        }
        this._featureTypeInfo = featureTypeInfo;
    }

    private void readRowValues() throws IOException {
        this._currentFieldsValues = new Object[this._numFields + 1];
        this._currentFieldsValues[this._numFields] = this._databasePortal.getString(TerralibServiceNative.getFEATURE_ID_COMPLETE_ATTRIBUTE_NAME());
        for (int i = 0; i < this._numFields; ++i) {
            Object value;
            if (i == this._geometryAttributeIndex) continue;
            this._currentFieldsValues[i] = value = this.getAttributeValue(i);
        }
        if (this._geometryAttributeIndex != -1) {
            this._currentFieldsValues[this._geometryAttributeIndex] = this.getGeometryValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        DatabasePortal databasePortal = this._databasePortal;
        synchronized (databasePortal) {
            this._databasePortal.setToFreeNativeTarget(true);
            this._databasePortal.delete();
            if (!this._closed) {
                this._terralibService.releaseLock(this._lockUUID);
            }
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        DatabasePortal databasePortal = this._databasePortal;
        synchronized (databasePortal) {
            if (this._closed) {
                return;
            }
            this._databasePortal.freeResult();
            this._terralibService.releaseLock(this._lockUUID);
            this._closed = true;
        }
    }

    public int getAttributeCount() {
        return this._numFields;
    }

    public AttributeDescriptor getAttributeType(int index) throws ArrayIndexOutOfBoundsException {
        if (index >= this._numFields || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Field index should be between 0 and " + this._attributeDescriptors.size() + ". Index = " + index);
        }
        return this._attributeDescriptors.get(index);
    }

    public boolean hasNext() throws IOException {
        return this._databasePortal.hasNext();
    }

    public void next() throws IOException {
        this._writeBuffer = null;
        if (this.hasNext()) {
            this.readRowValues();
        } else {
            this._currentFieldsValues = new Object[this._numFields + 1];
            this._currentWriteMode = WriteMode.INSERT;
        }
    }

    public Object read(int index) throws IOException, ArrayIndexOutOfBoundsException {
        if (index >= this._numFields || index < 0) {
            throw new ArrayIndexOutOfBoundsException("Field index should be between 0 and " + this._attributeDescriptors.size() + ". Index = " + index);
        }
        return this._currentFieldsValues[index];
    }

    private Object getGeometryValue() throws IOException {
        TypeAttributeMap typeMap = TypeAttributeMap.fromGeometryType(this._featureTypeInfo.getDefaultGeometryType());
        switch (typeMap) {
            case TA_LINES: {
                return this._databasePortal.fetchLine();
            }
            case TA_MULTIPOINT: {
                return this._databasePortal.fetchPoint();
            }
            case TA_MULTIPOLYGON: {
                return this._databasePortal.fetchPolygon();
            }
        }
        throw new IOException("Binding type not recognized : " + this._featureTypeInfo.getDefaultGeometryType().getBinding().getCanonicalName());
    }

    private Object getAttributeValue(int index) throws IOException {
        AttributeDescriptor attribute = this._attributeDescriptors.get(index);
        String attributeName = attribute.getLocalName();
        String attributeFullName = this._featureTypeInfo.getAttributeTableName(attributeName) + "." + attributeName;
        TypeAttributeMap typeMap = TypeAttributeMap.fromAttributeType(attribute.getType());
        switch (typeMap) {
            case TA_INTEGER: {
                return this._databasePortal.getInt(attributeFullName);
            }
            case TA_STRING: {
                return this._databasePortal.getString(attributeFullName);
            }
            case TA_REAL: {
                return this._databasePortal.getDouble(attributeFullName);
            }
            case TA_DATE: {
                Date date;
                String data = this._databasePortal.getDate(attributeFullName);
                try {
                    date = this.buildDateFormat().parse(data);
                }
                catch (ParseException e) {
                    throw new IOException("Error parsing date field (" + data + ") to Java Date.", e);
                }
                return date;
            }
        }
        throw new TerralibProviderRuntimeException("Error reading attribute value. Unsupported data type: " + (Object)((Object)typeMap));
    }

    public void write(int position, Object attribute) throws IOException {
        if (position < 0 || position >= this._numFields) {
            throw new IllegalArgumentException("The position should be in the current row's range [0," + this._numFields + ").");
        }
        if (this._writeBuffer == null) {
            assert (this._currentFieldsValues != null && this._currentFieldsValues.length == this._numFields);
            this._writeBuffer = new Object[this._numFields + 1];
        }
        this._writeBuffer[position] = attribute;
    }

    @Override
    public void flush(boolean writeOnlyGeometries) throws IOException {
        if (this._writeBuffer == null) {
            return;
        }
        Object attributeToWrite = null;
        int attributeIndex = 0;
        PersistenceTransferenceObject transferenceObject = new PersistenceTransferenceObject();
        for (AttributeDescriptor attrDesc : this._attributeDescriptors) {
            attributeToWrite = this._writeBuffer[attributeIndex];
            if (attributeToWrite != null) {
                this.setTransferenceValue(attrDesc, attributeToWrite, transferenceObject);
            }
            ++attributeIndex;
        }
        String typeName = this._featureTypeInfo.getTypeName();
        try {
            if (this._currentWriteMode == WriteMode.UPDATE) {
                this.addCurrentFeatureId(transferenceObject);
                this._terralibService.update(typeName, transferenceObject, writeOnlyGeometries);
            } else {
                if (this.getObjectId() != null) {
                    this.addCurrentFeatureId(transferenceObject);
                }
                String newFeatureId = this._terralibService.insert(typeName, transferenceObject, writeOnlyGeometries);
                this.updateWriteBufferFeatureId(newFeatureId);
            }
        }
        catch (Throwable t) {
            _logger.error((Object)("Attribute " + (Object)((Object)this._currentWriteMode) + " failed."), t);
            throw new IOException("Attribute " + (Object)((Object)this._currentWriteMode) + " failed.", t);
        }
        this.updateReadBufferFromWriteBuffer();
        this._writeBuffer = null;
    }

    private void addCurrentFeatureId(PersistenceTransferenceObject transferenceObject) {
        String featureIdCompleteAttributeName = TerralibServiceNative.getFEATURE_ID_COMPLETE_ATTRIBUTE_NAME();
        transferenceObject.setStringAttribute(featureIdCompleteAttributeName, this.getObjectId());
    }

    private int findAttributeIndexByName(String attributeName) {
        for (int attributeDescriptorIndex = 0; attributeDescriptorIndex < this._attributeDescriptors.size(); ++attributeDescriptorIndex) {
            if (!this._attributeDescriptors.get(attributeDescriptorIndex).getLocalName().equals(attributeName)) continue;
            return attributeDescriptorIndex;
        }
        return -1;
    }

    private void updateWriteBufferFeatureId(String newFeatureId) {
        this.setObjectId(newFeatureId);
    }

    private void updateReadBufferFromWriteBuffer() {
        Object updatedAttribute = null;
        for (int attributeIndex = 0; attributeIndex < this._writeBuffer.length; ++attributeIndex) {
            updatedAttribute = this._writeBuffer[attributeIndex];
            if (updatedAttribute == null) continue;
            this._currentFieldsValues[attributeIndex] = updatedAttribute;
        }
    }

    private SimpleDateFormat buildDateFormat() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    }

    private void setTransferenceValue(AttributeDescriptor attributeDescription, Object attributeValue, PersistenceTransferenceObject transferenceObject) {
        Class bindingClass = attributeDescription.getType().getBinding();
        String attributeName = attributeDescription.getLocalName();
        String completeAttributeName = this._featureTypeInfo.getAttributeTableName(attributeName) + "." + attributeName;
        TypeAttributeMap typeMap = TypeAttributeMap.fromAttributeType(attributeDescription.getType());
        switch (typeMap) {
            case TA_INTEGER: {
                Integer integerAttribute = attributeValue instanceof Long ? Integer.valueOf(((Long)attributeValue).intValue()) : (Integer)attributeValue;
                transferenceObject.setIntegerAttribute(completeAttributeName, integerAttribute);
                break;
            }
            case TA_REAL: {
                Double doubleAttribute = (Double)attributeValue;
                transferenceObject.setDoubleAttribute(completeAttributeName, doubleAttribute);
                break;
            }
            case TA_STRING: {
                String stringAttribute = (String)attributeValue;
                transferenceObject.setStringAttribute(completeAttributeName, stringAttribute);
                break;
            }
            case TA_DATE: {
                Date dateAttribute = (Date)attributeValue;
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                System.out.println(format.format(dateAttribute));
                transferenceObject.setDateAttribute(completeAttributeName, format.format(dateAttribute));
                break;
            }
            case TA_MULTIPOINT: {
                MultiPoint pointGeometries = (MultiPoint)attributeValue;
                transferenceObject.setPointGeometries(pointGeometries);
                break;
            }
            case TA_LINES: {
                MultiLineString lineGeometries = (MultiLineString)attributeValue;
                transferenceObject.setLineGeometries(lineGeometries);
                break;
            }
            case TA_MULTIPOLYGON: {
                MultiPolygon polygonGeometries = (MultiPolygon)attributeValue;
                transferenceObject.setPolygonGeometries(polygonGeometries);
                break;
            }
            default: {
                String message = "Unrecognized attribute class: \"" + bindingClass.getName() + "\".";
                _logger.error((Object)("Failed to set the transference attribute. Reason: " + message));
                throw new IllegalArgumentException(message);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._databasePortal.isClosed();
    }

    @Override
    public String getObjectId() {
        return (String)this._currentFieldsValues[this._numFields];
    }

    @Override
    public void setObjectId(String objectId) {
        this._currentFieldsValues[this._numFields] = objectId;
    }

    private static enum WriteMode {
        UPDATE,
        INSERT;

    }
}

