/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.swig;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.geotools.data.terralib.exception.IllegalStateException;
import org.geotools.data.terralib.exception.InvalidCrsWktException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.swig.CoreJNI;
import org.geotools.data.terralib.swig.DBConnection;
import org.geotools.data.terralib.swig.PersistenceTransferenceObject;
import org.geotools.data.terralib.swig.StringVector;
import org.geotools.data.terralib.swig.TeAttrDataType;
import org.geotools.data.terralib.swig.TeGeomRep;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptor;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptorVector;

public class TerralibServiceNative {
    private long swigCPtr;
    protected boolean swigCMemOwn;
    private static final Logger _logger = Logger.getLogger(TerralibServiceNative.class);

    protected TerralibServiceNative(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(TerralibServiceNative obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    public synchronized void setToFreeNativeTarget(boolean isToFreenativeTarget) {
        this.swigCMemOwn = isToFreenativeTarget;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L && this.swigCMemOwn) {
            this.swigCMemOwn = false;
            CoreJNI.delete_TerralibServiceNative(this.swigCPtr);
        }
        this.swigCPtr = 0L;
    }

    public static String getFEATURE_ID_COLUMN_NAME() {
        return CoreJNI.TerralibServiceNative_FEATURE_ID_COLUMN_NAME_get();
    }

    public static String getDEFAULT_GEOMETRY_TABLE_NAME() {
        return CoreJNI.TerralibServiceNative_DEFAULT_GEOMETRY_TABLE_NAME_get();
    }

    public static String getFEATURE_ID_COMPLETE_ATTRIBUTE_NAME() {
        return CoreJNI.TerralibServiceNative_FEATURE_ID_COMPLETE_ATTRIBUTE_NAME_get();
    }

    public static int getANY_LENGHT() {
        return CoreJNI.TerralibServiceNative_ANY_LENGHT_get();
    }

    public static String getALL_FEATURES_FEATURE_ID() {
        return CoreJNI.TerralibServiceNative_ALL_FEATURES_FEATURE_ID_get();
    }

    protected TerralibServiceNative(DBConnection connection) {
        this(CoreJNI.new_TerralibServiceNative(DBConnection.getCPtr(connection), connection), true);
    }

    public void getTypesNames(StringVector out) throws IllegalStateException {
        CoreJNI.TerralibServiceNative_getTypesNames(this.swigCPtr, this, StringVector.getCPtr(out), out);
    }

    protected void getViewIDs(StringVector out) {
        CoreJNI.TerralibServiceNative_getViewIDs(this.swigCPtr, this, StringVector.getCPtr(out), out);
    }

    protected void getViewTypesNames(String viewID, StringVector out) {
        CoreJNI.TerralibServiceNative_getViewTypesNames(this.swigCPtr, this, viewID, StringVector.getCPtr(out), out);
    }

    protected String getTypeProjectionWKT(String typeName) throws IllegalStateException, TypeNotFoundException {
        return CoreJNI.TerralibServiceNative_getTypeProjectionWKT(this.swigCPtr, this, typeName);
    }

    protected String getViewProjectionWKT(String viewID) throws TypeNotFoundException {
        return CoreJNI.TerralibServiceNative_getViewProjectionWKT(this.swigCPtr, this, viewID);
    }

    protected int getGeomRep(String typeName) throws IllegalStateException, TypeNotFoundException {
        return CoreJNI.TerralibServiceNative_getGeomRep(this.swigCPtr, this, typeName);
    }

    protected Envelope getBoundingBox(String typeName) throws IllegalStateException, TypeNotFoundException {
        return CoreJNI.TerralibServiceNative_getBoundingBox(this.swigCPtr, this, typeName);
    }

    protected TerralibAttributeDescriptorVector getTypeAttributes(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        return new TerralibAttributeDescriptorVector(CoreJNI.TerralibServiceNative_getTypeAttributes(this.swigCPtr, this, typeName), true);
    }

    public String insert(String typeName, PersistenceTransferenceObject transferObject, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        return CoreJNI.TerralibServiceNative_insert__SWIG_0(this.swigCPtr, this, typeName, PersistenceTransferenceObject.getCPtr(transferObject), transferObject, ignoreAttributes);
    }

    public String insert(String typeName, PersistenceTransferenceObject transferObject) throws IllegalStateException, TypeNotFoundException, IOException {
        return CoreJNI.TerralibServiceNative_insert__SWIG_1(this.swigCPtr, this, typeName, PersistenceTransferenceObject.getCPtr(transferObject), transferObject);
    }

    protected void createType(String typeName, TeGeomRep geomRep, String crsWkt) throws IOException, InvalidCrsWktException {
        CoreJNI.TerralibServiceNative_createType(this.swigCPtr, this, typeName, geomRep.swigValue(), crsWkt);
    }

    protected void linkAttributeTable(String typeName, String tableName, String linkAttributeColumn) throws TypeNotFoundException, IllegalStateException, IOException {
        CoreJNI.TerralibServiceNative_linkAttributeTable(this.swigCPtr, this, typeName, tableName, linkAttributeColumn);
    }

    protected void createAttributeTable(String tableName, TerralibAttributeDescriptorVector attributes) throws IllegalStateException, IOException {
        CoreJNI.TerralibServiceNative_createAttributeTable(this.swigCPtr, this, tableName, TerralibAttributeDescriptorVector.getCPtr(attributes), attributes);
    }

    public void update(String typeName, PersistenceTransferenceObject transferObject, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        CoreJNI.TerralibServiceNative_update__SWIG_0(this.swigCPtr, this, typeName, PersistenceTransferenceObject.getCPtr(transferObject), transferObject, ignoreAttributes);
    }

    public void update(String typeName, PersistenceTransferenceObject transferObject) throws IllegalStateException, TypeNotFoundException, IOException {
        CoreJNI.TerralibServiceNative_update__SWIG_1(this.swigCPtr, this, typeName, PersistenceTransferenceObject.getCPtr(transferObject), transferObject);
    }

    public void remove(String typeName, String featureId, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        CoreJNI.TerralibServiceNative_remove__SWIG_0(this.swigCPtr, this, typeName, featureId, ignoreAttributes);
    }

    public void remove(String typeName, String featureId) throws IllegalStateException, TypeNotFoundException, IOException {
        CoreJNI.TerralibServiceNative_remove__SWIG_1(this.swigCPtr, this, typeName, featureId);
    }

    public void removeAllFeatures(String typeName, boolean ignoreAttributes) throws IllegalStateException, TypeNotFoundException, IOException {
        CoreJNI.TerralibServiceNative_removeAllFeatures(this.swigCPtr, this, typeName, ignoreAttributes);
    }

    protected TerralibAttributeDescriptor buildTerralibAttributeDescriptor(String name, boolean isNullable, boolean isPrimaryKey, int length, TeAttrDataType type) {
        return new TerralibAttributeDescriptor(CoreJNI.TerralibServiceNative_buildTerralibAttributeDescriptor(this.swigCPtr, this, name, isNullable, isPrimaryKey, length, type.swigValue()), true);
    }

    public void dispose() {
        CoreJNI.TerralibServiceNative_dispose(this.swigCPtr, this);
    }

    public void dropFeatureType(String typeName, boolean ignoreAttributes) throws IOException, TypeNotFoundException {
        CoreJNI.TerralibServiceNative_dropFeatureType__SWIG_0(this.swigCPtr, this, typeName, ignoreAttributes);
    }

    public void dropFeatureType(String typeName) throws IOException, TypeNotFoundException {
        CoreJNI.TerralibServiceNative_dropFeatureType__SWIG_1(this.swigCPtr, this, typeName);
    }

    public int getGeometryCount(String typeName) throws TypeNotFoundException, IOException {
        return CoreJNI.TerralibServiceNative_getGeometryCount(this.swigCPtr, this, typeName);
    }

    public void reloadMetadata() {
        CoreJNI.TerralibServiceNative_reloadMetadata(this.swigCPtr, this);
    }
}

