/**
 * Tecgraf - GIS development team
 * 
 * Tdk Framework
 * Copyright TecGraf 2009(c).
 * 
 * file: FeatureTypeInfo.java
 * created: 12/01/2009
 */
package org.geotools.data.terralib;

import java.util.List;

import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;

/**
 * @author fmoura
 *
 */
public class FeatureTypeInfo
{

    private TerralibFeatureType _featureType;
    
    public FeatureTypeInfo(TerralibFeatureType featureType)
    {
        _featureType = featureType;
    }
    

    /**
     * @return
     * @since
     */
    public String getTypeName()
    {
        // TODO Auto-generated method stub
        return _featureType.getTypeName();
    }
    
    
    /**
     * 
     * @return
     * @since
     */
    public GeometryType getDefaultGeometryType()
    {
        return _featureType.getGeometryDescriptor().getType();
    }

    /**
     * @return
     * @since
     */
    public GeometryDescriptor getDefaultGeometryDescriptor()
    {
        return _featureType.getGeometryDescriptor();
    }


    /**
     * @return
     * @since
     */
    public List<AttributeDescriptor> getTypeAttributeList()
    {
        
        return _featureType.getAttributeDescriptors();
    }
    
    /**
     * 
     * @param attributeName
     * @return
     * @since
     */
    public String getAttributeTableName(String attributeName)
    {
        return _featureType.getAttributeTableName(attributeName);
    }
    
}
