package org.geotools.data.terralib.util.thread;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import java.util.Map.Entry;

import org.apache.log4j.Logger;




public class Watchdog extends TimerTask
{
	
	private Map<String,TerralibWatchdogTask> _tasks = new HashMap<String,TerralibWatchdogTask>();
	private Map<String,Long> _timers = new HashMap<String,Long>();
	private long _baseStepTimeMilliseconds;
	
	private static Logger _logger = Logger.getLogger(Watchdog.class);
	
	public Watchdog(long watchdogCheckStepMilliseconds) {
		_baseStepTimeMilliseconds = watchdogCheckStepMilliseconds;
	}

	synchronized public void add(String id,long threadId, StackTraceElement[] lockedMethod, long lockerThreadID, StackTraceElement[] lockerMethod , long time)
	{
		TerralibWatchdogTask task = new TerralibWatchdogTask(id,threadId,lockedMethod,lockerThreadID,lockerMethod);
		_tasks.put(id, task);
		_timers.put(id, time/_baseStepTimeMilliseconds);
	}
	
	synchronized public void remove(String id)
	{
		_tasks.remove(id);
		_timers.remove(id);
	}
	
	@Override
	synchronized public void run() {
		
		
		Set<String> finished = new HashSet<String>();
		for(Entry<String,TerralibWatchdogTask> entry : _tasks.entrySet())
		{
			TerralibWatchdogTask task = entry.getValue();
			long time = _timers.get(task.getId());
			if(time == 0)
			{
				task.run();
				finished.add(entry.getKey());
			}
			else
			{
				_timers.put(entry.getKey(), time-1);
			}
			
		}
		
		for(String threadId : finished)
		{
			_tasks.remove(threadId);
			_timers.remove(threadId);
		}
		
	}
	
}

class TerralibWatchdogTask implements Runnable 
{
	private static final int MAX_STACK_LEVELS = 15;
	private long _threadId;
	private StackTraceElement[] _lockedStack;
	private StackTraceElement[] _lockerStack;
	private String _id;
	private long _lockerThreadID;
	private static Logger _logger = Logger.getLogger(TerralibWatchdogTask.class);
	
	public TerralibWatchdogTask(String uuid ,long threadId,StackTraceElement[] lockedMethod, long lockerThreadID,StackTraceElement[] lockerMethod)
	{
		_id = uuid;
		_threadId = threadId;
		_lockedStack = lockedMethod;
		_lockerThreadID = lockerThreadID;
		_lockerStack = lockerMethod;
	}
	
	public String getId() {
		return _id;
	}

	@Override
	public void run() {
		StringBuilder message = new StringBuilder();
		message.append("Thread ").append(_threadId).append(" seems to be stuck\n");
		printStackTrace(message,_lockedStack);
		message.append("Last lock aquired by Thread ").append(_lockerThreadID).append("\n");
		printStackTrace(message,_lockerStack);
		_logger.warn(message);
	}
	
	private void printStackTrace(StringBuilder message,StackTraceElement[] stackTrace)
	{
		int min = Math.min(2, stackTrace.length);
		int max = Math.min(MAX_STACK_LEVELS, stackTrace.length);
		for(int i = min ; i < max ; i++)
		{
			StackTraceElement call = stackTrace[i];
			message.append("\t at ").append(call).append("\n");
		}
		if(stackTrace.length > MAX_STACK_LEVELS)
		{
			message.append("\t ...").append("\n");
		}
	}

	public long getThreadId() {
		return _threadId;
	}
}