/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.terralib.TerralibLayerDataType;
import org.geotools.data.terralib.TerralibService;
import org.geotools.data.terralib.ThreadBlockingTerralibService;
import org.geotools.data.terralib.exception.IllegalStateException;
import org.geotools.data.terralib.exception.InvalidCrsWktException;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TerralibProviderRuntimeException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.persistence.exception.InvalidAttributeException;
import org.geotools.data.terralib.swig.DBConnection;
import org.geotools.data.terralib.swig.StringVector;
import org.geotools.data.terralib.swig.TeAttrDataType;
import org.geotools.data.terralib.swig.TeGeomRep;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptor;
import org.geotools.data.terralib.swig.TerralibAttributeDescriptorVector;
import org.geotools.data.terralib.util.TerralibAttributeDescriptorTranslator;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultTerralibService
extends ThreadBlockingTerralibService
implements TerralibService {
    public DefaultTerralibService(DBConnection connection, boolean enableLocking) {
        super(connection, enableLocking);
    }

    public DefaultTerralibService(DBConnection connection) {
        this(connection, false);
    }

    @Override
    public CoordinateReferenceSystem getTypeCRS(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        String wktString = null;
        wktString = this.getTypeProjectionWKT(typeName);
        wktString = wktString.replaceAll("[eE]\\+", "E");
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.parseWKT((String)wktString);
        }
        catch (FactoryException e) {
            throw new TerralibProviderRuntimeException("Could not parse the terralib generated wkt.", e);
        }
        return crs;
    }

    @Override
    public CoordinateReferenceSystem getViewCRS(String viewID) throws TypeNotFoundException, IOException {
        String wktString = null;
        wktString = this.getViewProjectionWKT(viewID);
        wktString = wktString.replaceAll("[eE]\\+", "E");
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.parseWKT((String)wktString);
        }
        catch (FactoryException e) {
            throw new TerralibProviderRuntimeException("Could not parse the terralib generated wkt.", e);
        }
        return crs;
    }

    protected Set<TeGeomRep> getTypeGeometryTypes(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        HashSet<TeGeomRep> geomRepSet = new HashSet<TeGeomRep>();
        int rawGeomRep = this.getGeomRep(typeName);
        for (TeGeomRep geomRep : TeGeomRep.values()) {
            if ((rawGeomRep & geomRep.swigValue()) != geomRep.swigValue()) continue;
            geomRepSet.add(geomRep);
        }
        return geomRepSet;
    }

    @Override
    public Set<GeometryDescriptor> getTypeGeometryDescriptors(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        Set<TeGeomRep> geomTypeSet = this.getTypeGeometryTypes(typeName);
        CoordinateReferenceSystem crs = this.getTypeCRS(typeName);
        return TerralibAttributeDescriptorTranslator.buildGeometryDescriptorSet(geomTypeSet, crs);
    }

    @Override
    public Map<String, List<AttributeDescriptor>> getTypeAttributeDescriptors(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        HashMap<String, List<AttributeDescriptor>> typeDescriptorMap = new HashMap<String, List<AttributeDescriptor>>();
        TerralibAttributeDescriptorVector typeAttributes = this.getTypeAttributes(typeName);
        long typeAttributesSize = typeAttributes.size();
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        for (long i = 0L; i < typeAttributesSize; ++i) {
            TerralibAttributeDescriptor attribute = typeAttributes.get(i);
            String attributeName = attribute.getName();
            String attributeTableName = attributeName.substring(0, attributeName.indexOf(46));
            AttributeDescriptor attributeDescriptor = TerralibAttributeDescriptorTranslator.terralibDescriptorToGeotoolsDescriptor(attributeTypeBuilder, attribute);
            if (!typeDescriptorMap.containsKey(attributeTableName)) {
                typeDescriptorMap.put(attributeTableName, new ArrayList());
            }
            ((List)typeDescriptorMap.get(attributeTableName)).add(attributeDescriptor);
        }
        return typeDescriptorMap;
    }

    @Override
    public ReferencedEnvelope getTypeBoundingBox(String typeName) throws MismatchedDimensionException, IllegalStateException, TypeNotFoundException, IOException {
        return new ReferencedEnvelope(this.getBoundingBox(typeName), this.getTypeCRS(typeName));
    }

    @Override
    public String[] getViewIDs() throws IOException {
        StringVector out = new StringVector();
        this.getViewIDs(out);
        int typeNamesSize = (int)out.size();
        String[] viewIDs = new String[typeNamesSize];
        for (int i = 0; i < typeNamesSize; ++i) {
            viewIDs[i] = out.get(i);
        }
        return viewIDs;
    }

    @Override
    public String[] getViewTypesNames(String viewID) throws IOException {
        StringVector out = new StringVector();
        this.getViewTypesNames(viewID, out);
        int typeNamesSize = (int)out.size();
        String[] typeNames = new String[typeNamesSize];
        for (int i = 0; i < typeNamesSize; ++i) {
            typeNames[i] = out.get(i);
        }
        return typeNames;
    }

    @Override
    public String[] getTypeNames() throws IllegalStateException, IOException {
        StringVector out = new StringVector();
        this.getTypesNames(out);
        int typeNamesSize = (int)out.size();
        String[] typeNames = new String[typeNamesSize];
        for (int i = 0; i < typeNamesSize; ++i) {
            typeNames[i] = out.get(i);
        }
        return typeNames;
    }

    @Override
    public void createType(String typeName, GeometryDescriptor geometryDesc, CoordinateReferenceSystem projection) throws InvalidCrsWktException, IOException {
        if (geometryDesc == null) {
            throw new NullArgumentException("geometryDesc");
        }
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        if (projection == null) {
            throw new NullArgumentException("projection");
        }
        TypeAttributeMap type = TypeAttributeMap.fromBindingClass(geometryDesc.getType().getBinding());
        if (type == null) {
            throw new IllegalArgumentException("Unsupported geometry at GeometryDescriptor: " + geometryDesc.getType().getBinding().getName());
        }
        CoordinateReferenceSystem completeCrs = null;
        try {
            completeCrs = CRS.decode((String)("EPSG:" + CRS.lookupEpsgCode((CoordinateReferenceSystem)projection, (boolean)true)));
        }
        catch (Exception e) {
            throw new InvalidCrsWktException("Error trying to get more information about the given coordinate reference system.", e);
        }
        this.createType(typeName, type.getGeomRep(), completeCrs.toWKT());
    }

    @Override
    public TerralibAttributeDescriptor buildTerralibAttributeDescriptor(String name, boolean isNullable, boolean isPrimaryKey, int length, TeAttrDataType type) {
        if (name == null) {
            throw new NullArgumentException("name");
        }
        if (type == null) {
            throw new NullArgumentException("type");
        }
        TypeAttributeMap typeMap = TypeAttributeMap.fromTeAttrDataType(type);
        if (typeMap == null) {
            throw new InvalidAttributeException("Unrecognized attribute type " + (Object)((Object)type));
        }
        if (isPrimaryKey && isNullable) {
            throw new InvalidAttributeException("Primary keys can't be nullable");
        }
        if (typeMap.isGeometry() && length != DefaultTerralibService.getANY_LENGHT()) {
            throw new InvalidAttributeException("You can not specify an attribute length for geometry types.");
        }
        return super.buildTerralibAttributeDescriptor(name, isNullable, isPrimaryKey, length, type);
    }

    @Override
    public void createAttributeTable(String tableName, List<AttributeDescriptor> attributes) throws IllegalStateException, IOException {
        if (tableName == null) {
            throw new NullArgumentException("tableName");
        }
        if (attributes == null) {
            throw new NullArgumentException("attributes");
        }
        TerralibAttributeDescriptorVector teAttributes = new TerralibAttributeDescriptorVector();
        for (AttributeDescriptor attrDesc : attributes) {
            TerralibAttributeDescriptor teDescriptor = TerralibAttributeDescriptorTranslator.geotoolsDescriptorToTerralibDescriptor(this, attrDesc);
            teAttributes.add(teDescriptor);
        }
        this.createAttributeTable(tableName, teAttributes);
    }

    @Override
    public void linkAttributeTable(String typeName, String tableName, String linkAttributeColumn) throws IOException, TypeNotFoundException, IllegalStateException {
        if (tableName == null) {
            throw new NullArgumentException("tableName");
        }
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        if (linkAttributeColumn == null) {
            throw new NullArgumentException("linkAttributeColumn");
        }
        super.linkAttributeTable(typeName, tableName, linkAttributeColumn);
    }

    @Override
    public TerralibLayerDataType getLayerType(String typeName) throws IllegalStateException, TypeNotFoundException, IOException {
        Set<TeGeomRep> gemetryTypeSet = this.getTypeGeometryTypes(typeName);
        if (gemetryTypeSet.contains((Object)TeGeomRep.TeRASTERFILE)) {
            return TerralibLayerDataType.COVERAGE;
        }
        if (gemetryTypeSet.contains((Object)TeGeomRep.TeLINES) || gemetryTypeSet.contains((Object)TeGeomRep.TePOINTS) || gemetryTypeSet.contains((Object)TeGeomRep.TePOLYGONS)) {
            return TerralibLayerDataType.VECTOR;
        }
        return TerralibLayerDataType.NONE;
    }

    @Override
    public List<URL> getRasterFileURL(String typeName) throws TypeNotFoundException, IllegalStateException, IOException {
        StringVector filePaths = this.getRasterFilePath(typeName);
        ArrayList<URL> filesURLs = new ArrayList<URL>();
        int i = 0;
        while ((long)i < filePaths.size()) {
            String filePath = filePaths.get(i);
            filesURLs.add(new URL("file:///" + filePath));
            ++i;
        }
        return filesURLs;
    }
}

