/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.feature;

import java.io.IOException;
import org.geotools.data.AttributeReader;
import org.geotools.data.DefaultFeatureReader;
import org.geotools.data.terralib.query.TerralibQueryData;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class TerralibFeatureReader
extends DefaultFeatureReader {
    private SimpleFeatureBuilder _builder;

    public TerralibFeatureReader(AttributeReader attributeReader, SimpleFeatureType schema) throws SchemaException {
        super(attributeReader, schema);
        SimpleFeatureType typeSchema = schema;
        if (typeSchema == null) {
            typeSchema = this.createSchema();
        }
        this._builder = new SimpleFeatureBuilder(typeSchema);
    }

    protected SimpleFeature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        if (!(atts instanceof TerralibQueryData)) {
            throw new IllegalAttributeException("TerralibFeatureRead's attribute reader should be a TerralibQueryData");
        }
        String id = ((TerralibQueryData)atts).getObjectId();
        int ii = atts.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            this.attributes[i] = atts.read(i);
        }
        this._builder.addAll(this.attributes);
        return this._builder.buildFeature(id);
    }
}

