/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib.util;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Date;
import org.geotools.data.terralib.swig.TeAttrDataType;
import org.geotools.data.terralib.swig.TeGeomRep;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryType;

public enum TypeAttributeMap {
    TA_INTEGER(TeAttrDataType.TeINT, Integer.class, null),
    TA_LONG(TeAttrDataType.TeINT, Long.class, null),
    TA_REAL(TeAttrDataType.TeREAL, Double.class, null),
    TA_STRING(TeAttrDataType.TeSTRING, String.class, null),
    TA_DATE(TeAttrDataType.TeDATETIME, Date.class, null),
    TA_MULTIPOINT(TeAttrDataType.TePOINTTYPE, MultiPoint.class, TeGeomRep.TePOINTS),
    TA_MULTILINE(TeAttrDataType.TeLINE2DTYPE, MultiLineString.class, TeGeomRep.TeLINES),
    TA_MULTIPOLYGON(TeAttrDataType.TePOLYGONTYPE, MultiPolygon.class, TeGeomRep.TePOLYGONS),
    TA_POINT(TeAttrDataType.TePOINTTYPE, Point.class, TeGeomRep.TePOINTS),
    TA_LINE(TeAttrDataType.TeLINE2DTYPE, LineString.class, TeGeomRep.TeLINES),
    TA_POLYGON(TeAttrDataType.TePOLYGONTYPE, Polygon.class, TeGeomRep.TePOLYGONS);

    private TeAttrDataType _terralibAttr;
    private Class<?> _bindingClass;
    private TeGeomRep _geoRep;

    private TypeAttributeMap(TeAttrDataType terralibAttr, Class<?> bindingClass, TeGeomRep geoRep) {
        this._terralibAttr = terralibAttr;
        this._bindingClass = bindingClass;
        this._geoRep = geoRep;
    }

    public Class<?> getBindingClass() {
        return this._bindingClass;
    }

    public TeAttrDataType getTeAttributeType() {
        return this._terralibAttr;
    }

    public TeGeomRep getGeomRep() {
        return this._geoRep;
    }

    public boolean isGeometry() {
        return this._geoRep != null;
    }

    public static TypeAttributeMap fromTeGeomRep(TeGeomRep geom) {
        for (int i = 0; i < TypeAttributeMap.values().length; ++i) {
            if (TypeAttributeMap.values()[i]._geoRep != geom) continue;
            return TypeAttributeMap.values()[i];
        }
        return null;
    }

    public static TypeAttributeMap fromTeAttrDataType(TeAttrDataType attrDataType) {
        for (int i = 0; i < TypeAttributeMap.values().length; ++i) {
            if (TypeAttributeMap.values()[i]._terralibAttr != attrDataType) continue;
            return TypeAttributeMap.values()[i];
        }
        return null;
    }

    public static TypeAttributeMap fromBindingClass(Class<?> binding) {
        for (int i = 0; i < TypeAttributeMap.values().length; ++i) {
            if (!TypeAttributeMap.values()[i]._bindingClass.isAssignableFrom(binding)) continue;
            return TypeAttributeMap.values()[i];
        }
        return null;
    }

    public static TypeAttributeMap fromGeometryType(GeometryType geomType) {
        return TypeAttributeMap.fromBindingClass(geomType.getBinding());
    }

    public static TypeAttributeMap fromAttributeType(AttributeType attrType) {
        return TypeAttributeMap.fromBindingClass(attrType.getBinding());
    }
}

