/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.terralib;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.terralib.DefaultTerralibService;
import org.geotools.data.terralib.FeatureTypeInfo;
import org.geotools.data.terralib.TerralibFeatureType;
import org.geotools.data.terralib.TerralibLayerDataType;
import org.geotools.data.terralib.connection.DBConnectionFactory;
import org.geotools.data.terralib.connection.DBConnectionParamUtils;
import org.geotools.data.terralib.exception.AttributeNameColisionException;
import org.geotools.data.terralib.exception.IllegalStateException;
import org.geotools.data.terralib.exception.InvalidCrsWktException;
import org.geotools.data.terralib.exception.NullArgumentException;
import org.geotools.data.terralib.exception.TypeNotFoundException;
import org.geotools.data.terralib.feature.TerralibFeatureReader;
import org.geotools.data.terralib.feature.TerralibFeatureReaderWriter;
import org.geotools.data.terralib.feature.TerralibFeatureStore;
import org.geotools.data.terralib.feature.attribute.DefaultTerralibAttributePersistenceHandler;
import org.geotools.data.terralib.feature.attribute.TerralibAttributePersistenceHandler;
import org.geotools.data.terralib.feature.attribute.TerralibAttributePersistenceHandlerTypeOperation;
import org.geotools.data.terralib.geometry.MultiTextGeometry;
import org.geotools.data.terralib.query.Querier;
import org.geotools.data.terralib.query.QuerierParams;
import org.geotools.data.terralib.query.QueryData;
import org.geotools.data.terralib.swig.DBConnection;
import org.geotools.data.terralib.swig.ViewElement;
import org.geotools.data.terralib.util.TerralibAttributeHelper;
import org.geotools.data.terralib.util.TypeAttributeMap;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class TerralibDataStore
extends AbstractDataStore
implements DataStore {
    private static final String[] RESERVED_NAMES = new String[]{"object_id"};
    private static final String[] ILLEGAL_WORDS = new String[]{"DROP TABLE", "CREATE TABLE", "DELETE FROM", "INSERT INTO", "UPDATE ", "!", ".", "[", "]", "`"};
    private DefaultTerralibService _terralibService;
    private Querier _querier;
    private HashSet<Hints.Key> _supportedHints = new HashSet();
    private TerralibAttributePersistenceHandler _persistenceHandler = new DefaultTerralibAttributePersistenceHandler();
    private static Logger _logger = Logger.getLogger(TerralibDataStore.class);

    public TerralibDataStore(DBConnectionFactory connectionFactory, Map<String, ? extends Serializable> connectionParams) {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("The connection factory reference can't be null.");
        }
        if (connectionParams == null) {
            throw new IllegalArgumentException("The TerraLib connection parameters map can't be null.");
        }
        DBConnectionParamUtils.checkParams(connectionParams);
        String dataStoreType = (String)((Object)connectionParams.get(DBConnectionParamUtils.DBDRIVER.key));
        DBConnection connection = null;
        boolean enableLocking = false;
        if ("Access".equalsIgnoreCase(dataStoreType)) {
            String path = (String)((Object)connectionParams.get(DBConnectionParamUtils.DBPATH.key));
            connection = connectionFactory.createAccessConnection(path);
            enableLocking = true;
        } else if ("SQLServer".equalsIgnoreCase(dataStoreType)) {
            String host = (String)((Object)connectionParams.get(DBConnectionParamUtils.HOST.key));
            String userName = (String)((Object)connectionParams.get(DBConnectionParamUtils.USER.key));
            String databaseName = (String)((Object)connectionParams.get(DBConnectionParamUtils.DBNAME.key));
            String password = (String)((Object)connectionParams.get(DBConnectionParamUtils.PASSWD.key));
            Integer portNumber = Integer.parseInt(connectionParams.get(DBConnectionParamUtils.PORT.key).toString());
            _logger.debug((Object)("Connecting to the Sql-Server database with host=" + host + ", databaseName=" + databaseName));
            connection = connectionFactory.createSQLServerConnection(host, userName, password, databaseName, portNumber);
            _logger.debug((Object)"Sql-Server database connection estabilished.");
            enableLocking = true;
        } else {
            throw new UnsupportedOperationException("Sorry, but this database type isn't supported yet.");
        }
        this._terralibService = new DefaultTerralibService(connection, enableLocking);
        this._querier = new Querier(this._terralibService);
        this._supportedHints.add(Hints.FEATURE_DETACHED);
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(String typeName) throws IOException {
        QueryData queryData;
        TerralibFeatureType schema = (TerralibFeatureType)this.getSchema(typeName);
        FeatureTypeInfo featureTypeInfo = new FeatureTypeInfo(schema);
        QuerierParams params = new QuerierParams(featureTypeInfo);
        try {
            queryData = this._querier.execute(params);
        }
        catch (TypeNotFoundException e) {
            throw new IOException("Error getting attribute reader for type '" + typeName + "'", e);
        }
        try {
            return new TerralibFeatureReader(queryData, (SimpleFeatureType)schema);
        }
        catch (SchemaException e) {
            throw new IOException("Error creating feature reader for type '" + typeName + "'", e);
        }
    }

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> createFeatureWriter(String typeName, Transaction transaction) throws IOException {
        QueryData queryData;
        TerralibFeatureType schema = (TerralibFeatureType)this.getSchema(typeName);
        FeatureTypeInfo featureTypeInfo = new FeatureTypeInfo(schema);
        QuerierParams params = new QuerierParams(featureTypeInfo);
        try {
            queryData = this._querier.execute(params);
        }
        catch (TypeNotFoundException e) {
            throw new IOException("Error getting attribute reader for type '" + typeName + "'", e);
        }
        try {
            return new TerralibFeatureReaderWriter(this.listenerManager, this._terralibService, queryData, schema, Transaction.AUTO_COMMIT, this._persistenceHandler);
        }
        catch (SchemaException e) {
            throw new IOException("Error creating feature reader for type '" + typeName + "'", e);
        }
    }

    public SimpleFeatureType getSchema(String typeName) throws IOException {
        String defaultGeometryTable;
        Map<String, List<AttributeDescriptor>> schema = null;
        Set<GeometryDescriptor> geometryDescriptorSet = null;
        try {
            schema = this._terralibService.getTypeAttributeDescriptors(typeName);
            geometryDescriptorSet = this._terralibService.getTypeGeometryDescriptors(typeName);
        }
        catch (IllegalStateException e) {
            throw new IOException("The database is in an illegal state", e);
        }
        catch (TypeNotFoundException e) {
            throw new IOException("Could not find type \"" + typeName + "\"", e);
        }
        GeometryDescriptor defaultGeometry = null;
        for (GeometryDescriptor geometryDescriptor : geometryDescriptorSet) {
            if (geometryDescriptor.getType().getBinding().equals(MultiPolygon.class)) {
                defaultGeometry = geometryDescriptor;
                break;
            }
            if (geometryDescriptor.getType().getBinding().equals(MultiLineString.class)) {
                defaultGeometry = geometryDescriptor;
                break;
            }
            if (geometryDescriptor.getType().getBinding().equals(MultiPoint.class)) {
                defaultGeometry = geometryDescriptor;
                break;
            }
            if (!geometryDescriptor.getType().getBinding().equals(MultiTextGeometry.class)) continue;
            defaultGeometry = geometryDescriptor;
            break;
        }
        if (schema.get(defaultGeometryTable = DefaultTerralibService.getDEFAULT_GEOMETRY_TABLE_NAME()) == null) {
            schema.put(defaultGeometryTable, new ArrayList());
        }
        schema.get(defaultGeometryTable).add((AttributeDescriptor)defaultGeometry);
        NameImpl featureTypeName = new NameImpl(typeName);
        TerralibFeatureType terralibFeatureType = null;
        try {
            terralibFeatureType = new TerralibFeatureType((Name)featureTypeName, schema, defaultGeometry, false, null, (AttributeType)BasicFeatureTypes.FEATURE, null);
        }
        catch (AttributeNameColisionException e) {
            throw new IOException("Error creating the TerralibFeatureType '" + featureTypeName + "'.", e);
        }
        return terralibFeatureType;
    }

    public String[] getViewIDs() throws IOException {
        return this._terralibService.getViewIDs();
    }

    public String getViewName(String viewID) throws IOException {
        try {
            return this._terralibService.getViewName(viewID);
        }
        catch (TypeNotFoundException e) {
            throw new IOException("Could not find the requested view.", e);
        }
    }

    public String[] getViewTypeNames(String viewID) throws IOException {
        if (viewID == null) {
            throw new NullArgumentException("viewID");
        }
        return this._terralibService.getViewTypesNames(viewID);
    }

    public ViewElement[] getViewStructure(String viewID) throws IOException {
        if (viewID == null) {
            throw new NullArgumentException("viewID");
        }
        return this._terralibService.getViewStructure(viewID);
    }

    public CoordinateReferenceSystem getViewCRS(String viewID) throws IOException {
        try {
            return this._terralibService.getViewCRS(viewID);
        }
        catch (TypeNotFoundException e) {
            throw new IOException("Coudl not find the requested view.", e);
        }
    }

    public String[] getTypeNames() throws IOException {
        try {
            return this._terralibService.getTypeNames();
        }
        catch (IllegalStateException e) {
            throw new IOException("Terralib database is in a invalid state", e);
        }
    }

    protected ReferencedEnvelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.EXCLUDE) {
            return new ReferencedEnvelope(this.getSchema(query.getTypeName()).getCoordinateReferenceSystem());
        }
        if (query.getFilter() == Filter.INCLUDE) {
            try {
                return this._terralibService.getTypeBoundingBox(query.getTypeName());
            }
            catch (TypeNotFoundException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (MismatchedDimensionException e) {
                throw new IOException(e.getMessage(), e);
            }
            catch (IllegalStateException e) {
                throw new IOException(e.getMessage(), e);
            }
        }
        ReferencedEnvelope envelope = new ReferencedEnvelope(this.getSchema(query.getTypeName()).getCoordinateReferenceSystem());
        FeatureCollection features = this.getFeatureSource(query.getTypeName()).getFeatures(query);
        for (SimpleFeature feature : features) {
            BoundingBox bounds = feature.getBounds();
            Envelope env = new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
            envelope.expandToInclude(env);
        }
        return envelope;
    }

    protected Set<Hints.Key> getSupportedHints() {
        return this._supportedHints;
    }

    public void dispose() {
        super.dispose();
        if (this._terralibService != null) {
            this._terralibService.dispose();
        }
    }

    public void setAttributePersistenceHandler(TerralibAttributePersistenceHandler persistenceHandler) {
        if (persistenceHandler == null) {
            throw new NullArgumentException("persistenceHandler");
        }
        this._persistenceHandler = persistenceHandler;
    }

    public TerralibAttributePersistenceHandler getAttributePersistenceHandler() {
        return this._persistenceHandler;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.validadeSchema(featureType);
        try {
            this._terralibService.createType(featureType.getTypeName(), featureType.getGeometryDescriptor(), featureType.getCoordinateReferenceSystem());
        }
        catch (InvalidCrsWktException e) {
            throw new IOException("The feature type's Coordinate Reference System is not supported by Terralib Provider.", e);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage(), e);
        }
        HashMap<String, String> linkTables = null;
        if (this._persistenceHandler.canProcess(featureType.getTypeName(), TerralibAttributePersistenceHandlerTypeOperation.CREATE_FEATURE_TYPE)) {
            try {
                linkTables = this._persistenceHandler.createFeatureTypeAttributes((FeatureType)featureType);
            }
            catch (IOException e) {
                try {
                    this._terralibService.dropFeatureType(featureType.getTypeName(), true);
                }
                catch (TypeNotFoundException e1) {
                    // empty catch block
                }
                throw e;
            }
            if (linkTables == null) {
                throw new IOException("Persistence handler shouldn't return null.");
            }
        } else {
            linkTables = new HashMap();
            if (featureType.getAttributeCount() > 1) {
                try {
                    this.createAttributeTable(featureType, linkTables);
                }
                catch (IOException e) {
                    try {
                        this._terralibService.dropFeatureType(featureType.getTypeName(), true);
                    }
                    catch (TypeNotFoundException e1) {
                        // empty catch block
                    }
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage(), e);
                }
            }
        }
        this.validateLinkTable(featureType, linkTables);
        for (Map.Entry linkTableEntry : linkTables.entrySet()) {
            try {
                this._terralibService.linkAttributeTable(featureType.getTypeName(), (String)linkTableEntry.getKey(), (String)linkTableEntry.getValue());
            }
            catch (Exception e) {
                this.undoLayerAttributeCreation(featureType, linkTables);
                throw new IOException("Error linking the attribute table to the layer", e);
            }
        }
    }

    protected void validateLinkTable(SimpleFeatureType featureType, Map<String, String> linkTables) throws IOException {
        for (Map.Entry<String, String> linkTableEntry : linkTables.entrySet()) {
            if (this.nameIsInvalid(linkTableEntry.getKey())) {
                this.undoLayerAttributeCreation(featureType, linkTables);
                throw new IOException("The link table name (" + linkTableEntry.getKey() + ") is invalid.");
            }
            if (!this.nameIsInvalid(linkTableEntry.getValue())) continue;
            this.undoLayerAttributeCreation(featureType, linkTables);
            throw new IOException("The link column name (" + linkTableEntry.getValue() + ") is invalid.");
        }
    }

    protected void undoLayerAttributeCreation(SimpleFeatureType featureType, Map<String, String> linkTables) throws IOException {
        if (this._persistenceHandler.canProcess(featureType.getTypeName(), TerralibAttributePersistenceHandlerTypeOperation.CREATE_FEATURE_TYPE)) {
            this._persistenceHandler.undoCreateFeatureTypeAttributes((FeatureType)featureType, linkTables);
            try {
                this._terralibService.dropFeatureType(featureType.getTypeName(), true);
            }
            catch (TypeNotFoundException e) {
                throw new IOException(e);
            }
        }
        try {
            this._terralibService.dropFeatureType(featureType.getTypeName());
        }
        catch (TypeNotFoundException e) {
            throw new IOException(e);
        }
    }

    protected void validadeSchema(SimpleFeatureType featureType) throws IOException {
        if (featureType == null) {
            throw new NullArgumentException("featureType");
        }
        if (this.nameIsInvalid(featureType.getTypeName())) {
            throw new IOException("The feature type's name " + featureType.getTypeName() + " is invalid.");
        }
        GeometryDescriptor geometry = featureType.getGeometryDescriptor();
        if (geometry == null) {
            throw new IOException("The feature type must have a default Geometry");
        }
        TypeAttributeMap geomType = TypeAttributeMap.fromBindingClass(geometry.getType().getBinding());
        if (!geomType.isGeometry()) {
            throw new IOException("The default geometry attribute is not a geometry.");
        }
        int numOfGeometries = 0;
        List attributes = featureType.getAttributeDescriptors();
        for (AttributeDescriptor desc : attributes) {
            TypeAttributeMap type = TypeAttributeMap.fromBindingClass(desc.getType().getBinding());
            if (type == null) {
                throw new IOException("Attribute " + desc.getLocalName() + " has a binding type (" + desc.getType().getBinding() + ") that is not supported by terralib.");
            }
            if (type == TypeAttributeMap.TA_LONG) {
                _logger.warn((Object)("Schema to create has an attribute " + desc.getLocalName() + " with type=LONG. Terralib does not support, so we'll convert it to INT."));
            }
            if (type.isGeometry()) {
                ++numOfGeometries;
            }
            if (this.isReservedName(desc.getLocalName())) {
                throw new IOException("One of the schema attributes is called " + desc.getLocalName() + ". That name is invalid because it's a reserved name at terralib.");
            }
            if (!this.nameIsInvalid(desc.getLocalName())) continue;
            throw new IOException("The attribute name " + desc.getLocalName() + " is invalid.");
        }
        if (numOfGeometries != 1) {
            throw new IOException("The feature type can have only one geometry attribute, the default Geometry.");
        }
    }

    protected boolean isReservedName(String localName) {
        for (String s : RESERVED_NAMES) {
            if (!s.equalsIgnoreCase(localName)) continue;
            return true;
        }
        return false;
    }

    protected String getAttributeTableName(SimpleFeatureType featureType) {
        return featureType.getTypeName() + "_attr";
    }

    protected void createAttributeTable(SimpleFeatureType featureType, Map<String, String> linkTables) throws IOException {
        ArrayList<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();
        for (AttributeDescriptor attrDesc : featureType.getAttributeDescriptors()) {
            if (TypeAttributeMap.fromBindingClass(attrDesc.getType().getBinding()).isGeometry()) continue;
            attributes.add(attrDesc);
        }
        String defaultColumnName = DefaultTerralibService.getFEATURE_ID_COLUMN_NAME();
        String linkColumnName = defaultColumnName + "0";
        int i = 0;
        while (this.columnExists(linkColumnName, attributes)) {
            linkColumnName = defaultColumnName + ++i;
        }
        attributes.add(TerralibAttributeHelper.buildType(linkColumnName, TypeAttributeMap.TA_STRING, false, false, 255));
        try {
            this._terralibService.createAttributeTable(this.getAttributeTableName(featureType), attributes);
        }
        catch (Exception e) {
            try {
                this._terralibService.dropFeatureType(featureType.getTypeName(), true);
            }
            catch (TypeNotFoundException e1) {
                // empty catch block
            }
            throw new IOException("Error creating the attribute table: " + e.getMessage(), e);
        }
        linkTables.put(this.getAttributeTableName(featureType), linkColumnName);
    }

    private boolean columnExists(String linkColumnName, List<AttributeDescriptor> attributes) {
        for (AttributeDescriptor attrDesc : attributes) {
            if (!attrDesc.getLocalName().equalsIgnoreCase(linkColumnName)) continue;
            return true;
        }
        return false;
    }

    protected int getCount(Query query) throws IOException {
        if (query == null) {
            throw new NullArgumentException("query");
        }
        String typeName = query.getTypeName();
        if (typeName != null && !typeName.equals("")) {
            if (this.nameIsInvalid(typeName)) {
                throw new IllegalArgumentException("The typename " + typeName + " is invalid.");
            }
            if (!query.getFilter().equals(Filter.INCLUDE)) {
                return -1;
            }
            try {
                return this._terralibService.getGeometryCount(typeName);
            }
            catch (TypeNotFoundException e) {
                throw new IOException(e);
            }
        }
        throw new IllegalArgumentException("The typename " + typeName + " is invalid.");
    }

    protected boolean nameIsInvalid(String name) {
        name = name.toUpperCase();
        for (String illegalWord : ILLEGAL_WORDS) {
            if (!name.contains(illegalWord)) continue;
            return true;
        }
        return name.length() > 0 && name.substring(0, 1).equals(" ");
    }

    public void dropSchema(String typeName) throws IOException {
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        if (this._persistenceHandler.canProcess(typeName, TerralibAttributePersistenceHandlerTypeOperation.DROP_FEATURE_TYPE)) {
            SimpleFeatureType feature = this.getSchema(typeName);
            try {
                this._terralibService.dropFeatureType(typeName, true);
            }
            catch (TypeNotFoundException e) {
                throw new IOException(e);
            }
            this._persistenceHandler.dropFeatureTypeAttributes((FeatureType)feature);
        } else {
            try {
                this._terralibService.dropFeatureType(typeName);
            }
            catch (TypeNotFoundException e) {
                throw new IOException(e);
            }
        }
    }

    public void reloadMetadata() {
        this._terralibService.reloadMetadata();
    }

    public static String[] getReservedNames() {
        String[] reservedNames = new String[RESERVED_NAMES.length];
        for (int i = 0; i < RESERVED_NAMES.length; ++i) {
            reservedNames[i] = RESERVED_NAMES[i];
        }
        return reservedNames;
    }

    public static String[] getIllegalWords() {
        String[] illegalWords = new String[ILLEGAL_WORDS.length];
        for (int i = 0; i < ILLEGAL_WORDS.length; ++i) {
            illegalWords[i] = ILLEGAL_WORDS[i];
        }
        return illegalWords;
    }

    public FeatureSource<SimpleFeatureType, SimpleFeature> getFeatureSource(String typeName) throws IOException {
        if (typeName == null) {
            throw new NullArgumentException("typeName");
        }
        return new TerralibFeatureStore(this, this._supportedHints, this.getSchema(typeName));
    }

    public void removeAllFeatures(String typeName) throws IOException {
        try {
            if (this._persistenceHandler.canProcess(typeName, TerralibAttributePersistenceHandlerTypeOperation.REMOVE)) {
                this._terralibService.removeAllFeatures(typeName, true);
                this._persistenceHandler.removeAll(typeName);
            } else {
                this._terralibService.removeAllFeatures(typeName, false);
            }
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
        catch (TypeNotFoundException e) {
            throw new IOException(e);
        }
    }

    public TerralibLayerDataType getLayerType(String typeName) throws IOException {
        try {
            return this._terralibService.getLayerType(typeName);
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
        catch (TypeNotFoundException e) {
            throw new IOException(e);
        }
    }

    public List<URL> getCoverageFilePath(String typeName) throws IOException {
        if (this.getLayerType(typeName) != TerralibLayerDataType.COVERAGE) {
            return new ArrayList<URL>();
        }
        try {
            return this._terralibService.getRasterFileURL(typeName);
        }
        catch (TypeNotFoundException e) {
            throw new IOException(e);
        }
        catch (IllegalStateException e) {
            throw new IOException(e);
        }
        catch (IOException e) {
            throw new IOException(e);
        }
    }
}

