/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.validation.FeatureValidation;
import org.geotools.validation.ValidationResults;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class DefaultFeatureValidation
implements FeatureValidation {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    private String name;
    private String description;
    private String typeRef;

    public final void setName(String name) {
        this.name = name;
    }

    public final String getName() {
        return this.name;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final String getDescription() {
        return this.description;
    }

    public int getPriority() {
        return 200;
    }

    public String[] getTypeRefs() {
        if (this.typeRef == null) {
            return null;
        }
        if (this.typeRef.equals("*")) {
            return ALL;
        }
        return new String[]{this.typeRef};
    }

    public String getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(String typeRef) {
        this.typeRef = typeRef;
    }

    public boolean validate(SimpleFeature feature, SimpleFeatureType type, ValidationResults results) {
        LOGGER.warning(this.getName() + " not implemented");
        results.warning(feature, " test not implemented");
        return false;
    }

    protected LineString getDefaultLineString(SimpleFeature feature) throws ClassCastException {
        Geometry geom = (Geometry)feature.getDefaultGeometry();
        if (geom == null) {
            return null;
        }
        if (geom instanceof LineString) {
            return (LineString)geom;
        }
        if (geom instanceof MultiLineString) {
            MultiLineString lines = (MultiLineString)geom;
            if (lines.getNumGeometries() == 1) {
                return (LineString)lines.getGeometryN(0);
            }
            throw new ClassCastException("MultiLineString does not contain a single LineString");
        }
        if (geom instanceof GeometryCollection) {
            GeometryCollection geoms = (GeometryCollection)geom;
            if (geoms.getNumGeometries() == 1 && geoms.getGeometryN(0) instanceof LineString) {
                return (LineString)geoms.getGeometryN(0);
            }
            throw new ClassCastException("GeometryCollection does not contain a single LineString");
        }
        throw new ClassCastException("Cannot convert to LineString");
    }
}

