/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.FeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelateIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    private String de9im;

    public final String getDe9imString() {
        return this.de9im;
    }

    public final void setDe9imString(String str) {
        this.de9im = str;
    }

    public boolean validate(Map layers, Envelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(typeRef1 + ": looking up FeatureSource<SimpleFeatureType, SimpleFeature> ");
        FeatureSource geomSource1 = (FeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + ((SimpleFeatureType)geomSource1.getSchema()).getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer((FeatureSource<SimpleFeatureType, SimpleFeature>)geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.finer(typeRef2 + ": looking up FeatureSource<SimpleFeatureType, SimpleFeature> ");
        FeatureSource geomSource2 = (FeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + ((SimpleFeatureType)geomSource2.getSchema()).getTypeName());
        return this.validateMultipleLayers((FeatureSource<SimpleFeatureType, SimpleFeature>)geomSource1, (FeatureSource<SimpleFeatureType, SimpleFeature>)geomSource2, this.isExpected(), results, envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMultipleLayers(FeatureSource<SimpleFeatureType, SimpleFeature> featureSourceA, FeatureSource<SimpleFeatureType, SimpleFeature> featureSourceB, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        boolean success = true;
        Filter filter = null;
        FeatureCollection collectionA = featureSourceA.getFeatures(filter);
        FeatureCollection collectionB = featureSourceB.getFeatures(filter);
        FeatureIterator fr1 = null;
        FeatureIterator fr2 = null;
        try {
            fr1 = collectionA.features();
            if (fr1 == null) {
                boolean bl = false;
                return bl;
            }
            while (fr1.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                fr2 = collectionB.features();
                while (fr2 != null && fr2.hasNext()) {
                    SimpleFeature f2 = (SimpleFeature)fr2.next();
                    Geometry g2 = (Geometry)f2.getDefaultGeometry();
                    if (g1.relate(g2, this.de9im) == expected) continue;
                    results.error(f1, ((Geometry)f1.getDefaultGeometry()).getGeometryType() + " " + this.getGeomTypeRefA() + " failed RELATE on " + this.getGeomTypeRefB() + "(" + f2.getID() + "), Result was not " + expected);
                    success = false;
                }
            }
        }
        finally {
            collectionA.close(fr1);
            collectionB.close(fr2);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateSingleLayer(FeatureSource<SimpleFeatureType, SimpleFeature> featureSourceA, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        boolean success = true;
        Filter filter = null;
        FeatureCollection collection = featureSourceA.getFeatures(filter);
        FeatureIterator fr1 = null;
        FeatureIterator fr2 = null;
        try {
            fr1 = collection.features();
            if (fr1 == null) {
                boolean bl = false;
                return bl;
            }
            while (fr1.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                fr2 = collection.features();
                while (fr2 != null && fr2.hasNext()) {
                    SimpleFeature f2 = (SimpleFeature)fr2.next();
                    Geometry g2 = (Geometry)f2.getDefaultGeometry();
                    if (f1.getID().equals(f2.getID()) || g1.overlaps(g2) == expected && g1.contains(g2) == expected) continue;
                    results.error(f1, ((Geometry)f1.getDefaultGeometry()).getGeometryType() + " " + this.getGeomTypeRefA() + " overlapped " + this.getGeomTypeRefA() + "(" + f2.getID() + "), Result was not " + expected);
                    success = false;
                }
            }
        }
        finally {
            collection.close(fr1);
            collection.close(fr2);
        }
        return success;
    }
}

