/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.validation.relate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.filter.IllegalFilterException;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.validation.ValidationResults;
import org.geotools.validation.relate.RelationIntegrity;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.geometry.BoundingBox;

public class CrossesIntegrity
extends RelationIntegrity {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.validation");
    private static HashSet usedIDs;

    public CrossesIntegrity() {
        usedIDs = new HashSet();
    }

    public boolean validate(Map layers, ReferencedEnvelope envelope, ValidationResults results) throws Exception {
        LOGGER.finer("Starting test " + this.getName() + " (" + this.getClass().getName() + ")");
        String typeRef1 = this.getGeomTypeRefA();
        LOGGER.finer(typeRef1 + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource geomSource1 = (SimpleFeatureSource)layers.get(typeRef1);
        LOGGER.finer(typeRef1 + ": found " + ((SimpleFeatureType)geomSource1.getSchema()).getTypeName());
        String typeRef2 = this.getGeomTypeRefB();
        if (typeRef2 == "" || typeRef1.equals(typeRef2)) {
            return this.validateSingleLayer(geomSource1, this.isExpected(), results, envelope);
        }
        LOGGER.finer(typeRef2 + ": looking up SimpleFeatureSource ");
        SimpleFeatureSource geomSource2 = (SimpleFeatureSource)layers.get(typeRef2);
        LOGGER.finer(typeRef2 + ": found " + ((SimpleFeatureType)geomSource2.getSchema()).getTypeName());
        return this.validateMultipleLayers(geomSource1, geomSource2, this.isExpected(), results, (Envelope)envelope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateMultipleLayers(SimpleFeatureSource featureSourceA, SimpleFeatureSource featureSourceB, boolean expected, ValidationResults results, Envelope bBox) throws Exception {
        boolean success = true;
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        Filter filter = null;
        SimpleFeatureCollection featureResultsA = featureSourceA.getFeatures(filter);
        SimpleFeatureCollection featureResultsB = featureSourceB.getFeatures(filter);
        SimpleFeatureIterator fr1 = null;
        SimpleFeatureIterator fr2 = null;
        try {
            fr1 = featureResultsA.features();
            if (fr1 == null) {
                boolean bl = success;
                return bl;
            }
            while (fr1.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                fr2 = featureResultsB.features();
                while (fr2 != null && fr2.hasNext()) {
                    SimpleFeature f2 = (SimpleFeature)fr2.next();
                    Geometry g2 = (Geometry)f2.getDefaultGeometry();
                    if (g1.overlaps(g2) == expected && g1.contains(g2) == expected) continue;
                    results.error(f1, ((Geometry)f1.getDefaultGeometry()).getGeometryType() + " " + this.getGeomTypeRefA() + " overlapped " + this.getGeomTypeRefB() + "(" + f2.getID() + "), Result was not " + expected);
                    success = false;
                }
            }
        }
        finally {
            fr1.close();
            if (fr2 != null) {
                fr2.close();
            }
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateSingleLayer(SimpleFeatureSource featureSourceA, boolean expected, ValidationResults results, ReferencedEnvelope bBox) throws Exception {
        boolean success = true;
        SimpleFeatureType ft = (SimpleFeatureType)featureSourceA.getSchema();
        Filter filter = this.filterBBox(bBox, ft);
        SimpleFeatureCollection featureResults = featureSourceA.getFeatures();
        SimpleFeatureIterator fr1 = null;
        SimpleFeatureIterator fr2 = null;
        try {
            fr1 = featureResults.features();
            if (fr1 == null) {
                boolean bl = success;
                return bl;
            }
            while (fr1.hasNext()) {
                SimpleFeature f1 = (SimpleFeature)fr1.next();
                Geometry g1 = (Geometry)f1.getDefaultGeometry();
                Filter filter2 = this.filterBBox(ReferencedEnvelope.reference((Envelope)g1.getEnvelope().getEnvelopeInternal()), ft);
                SimpleFeatureCollection featureResults2 = featureSourceA.getFeatures();
                fr2 = featureResults2.features();
                while (fr2 != null && fr2.hasNext()) {
                    SimpleFeature f2 = (SimpleFeature)fr2.next();
                    Geometry g2 = (Geometry)f2.getDefaultGeometry();
                    if (usedIDs.contains(f2.getID()) || f1.getID().equals(f2.getID()) || g1.crosses(g2) == expected) continue;
                    results.error(f1, this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " crossed " + this.getGeomTypeRefA() + "(" + f2.getID() + ")");
                    System.out.println(((Geometry)f1.getDefaultGeometry()).getGeometryType() + " " + this.getGeomTypeRefA() + "(" + f1.getID() + ")" + " crossed " + this.getGeomTypeRefA() + "(" + f2.getID() + "), Result was not " + expected);
                    success = false;
                }
                usedIDs.add(f1.getID());
            }
        }
        finally {
            fr1.close();
            if (fr2 != null) {
                fr2.close();
            }
        }
        return success;
    }

    private Filter filterBBox(ReferencedEnvelope bBox, SimpleFeatureType ft) throws FactoryRegistryException, IllegalFilterException {
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
        Disjoint filter = ff.disjoint((Expression)ff.property(ft.getGeometryDescriptor().getLocalName()), (Expression)ff.literal((Object)JTS.toGeometry((BoundingBox)bBox)));
        return filter;
    }
}

