/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.geotools.data.vpf.ColumnPair;
import org.geotools.data.vpf.VPFColumn;
import org.geotools.data.vpf.VPFCoverage;
import org.geotools.data.vpf.VPFLibrary;
import org.geotools.data.vpf.file.VPFFile;
import org.geotools.data.vpf.file.VPFFileFactory;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.ifc.FileConstants;
import org.geotools.data.vpf.readers.AreaGeometryFactory;
import org.geotools.data.vpf.readers.ConnectedNodeGeometryFactory;
import org.geotools.data.vpf.readers.EntityNodeGeometryFactory;
import org.geotools.data.vpf.readers.LineGeometryFactory;
import org.geotools.data.vpf.readers.TextGeometryFactory;
import org.geotools.data.vpf.readers.VPFGeometryFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.feature.type.AnnotationFeatureType;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFFeatureClass
implements DataTypesDefinition,
FileConstants,
SimpleFeatureType {
    private SimpleFeatureType featureType;
    private final List columns = new Vector();
    private final VPFCoverage coverage;
    private final String directoryName;
    private final AbstractList fileList = new Vector();
    private final AbstractList joinList = new Vector();
    private final String typeName;
    private final URI namespace;
    private VPFGeometryFactory geometryFactory;
    private boolean textTypeFeature = false;

    public VPFFeatureClass(VPFCoverage cCoverage, String cName, String cDirectoryName) throws SchemaException {
        this(cCoverage, cName, cDirectoryName, null);
    }

    public VPFFeatureClass(VPFCoverage cCoverage, String cName, String cDirectoryName, URI cNamespace) throws SchemaException {
        this.coverage = cCoverage;
        this.directoryName = cDirectoryName;
        this.typeName = cName;
        this.namespace = cNamespace == null ? VPFLibrary.DEFAULT_NAMESPACE : cNamespace;
        String fcsFileName = String.valueOf(this.directoryName) + File.separator + "fcs";
        try {
            VPFFile fcsFile = VPFFileFactory.getInstance().getFile(fcsFileName);
            for (SimpleFeature feature : fcsFile.readAllRows()) {
                String featureClassName = feature.getAttribute("feature_class").toString().trim();
                if (!this.typeName.equals(featureClassName)) continue;
                this.addFCS(feature);
            }
            Iterator iter = this.columns.iterator();
            GeometryDescriptor gat = null;
            AttributeDescriptor geometryColumn = null;
            while (iter.hasNext()) {
                geometryColumn = (AttributeDescriptor)iter.next();
                if (!Geometry.class.isAssignableFrom(geometryColumn.getType().getBinding())) continue;
                if (geometryColumn instanceof GeometryDescriptor) {
                    gat = (GeometryDescriptor)geometryColumn;
                    break;
                }
                if (!(geometryColumn instanceof VPFColumn)) break;
                gat = ((VPFColumn)geometryColumn).getGeometryAttributeType();
                break;
            }
            SimpleFeatureType superType = null;
            if (this.textTypeFeature) {
                superType = AnnotationFeatureType.ANNOTATION;
            }
            SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
            b.setName(cName);
            b.setNamespaceURI(this.namespace);
            b.setSuperType(superType);
            b.addAll(this.columns);
            b.setDefaultGeometry(gat.getLocalName());
            this.featureType = b.buildFeatureType();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    private void addFCS(SimpleFeature row) {
        String table1 = row.getAttribute("table1").toString();
        String table1Key = row.getAttribute("table1_key").toString();
        String table2 = row.getAttribute("table2").toString();
        String table2Key = row.getAttribute("table2_key").toString();
        try {
            AttributeDescriptor joinColumn2;
            VPFFile vpfFile1 = VPFFileFactory.getInstance().getFile(this.directoryName.concat(File.separator).concat(table1));
            this.addFileToTable(vpfFile1);
            VPFFile vpfFile2 = null;
            VPFColumn joinColumn1 = (VPFColumn)vpfFile1.getDescriptor(table1Key);
            try {
                vpfFile2 = VPFFileFactory.getInstance().getFile(this.directoryName.concat(File.separator).concat(table2));
                this.addFileToTable(vpfFile2);
                joinColumn2 = (VPFColumn)vpfFile2.getDescriptor(table2Key);
            }
            catch (IOException exc) {
                this.fileList.add(null);
                joinColumn2 = this.buildGeometryColumn(table2);
            }
            if (!this.joinList.contains(new ColumnPair(joinColumn2, joinColumn1))) {
                this.joinList.add(new ColumnPair(joinColumn1, joinColumn2));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private AttributeDescriptor buildGeometryColumn(String table) {
        AttributeDescriptor result = null;
        table = table.trim().toLowerCase();
        CoordinateReferenceSystem crs = this.getCoverage().getLibrary().getCoordinateReferenceSystem();
        result = crs != null ? new AttributeTypeBuilder().binding(Geometry.class).nillable(true).length(-1).crs(crs).buildDescriptor("GEOMETRY") : new AttributeTypeBuilder().binding(Geometry.class).nillable(true).buildDescriptor("GEOMETRY");
        this.columns.add(result);
        this.setGeometryFactory(table);
        return result;
    }

    private void setGeometryFactory(String table) {
        if (table.equals("edg")) {
            this.geometryFactory = new LineGeometryFactory();
        } else if (table.equals("fac")) {
            this.geometryFactory = new AreaGeometryFactory();
        } else if (table.equals("cnd")) {
            this.geometryFactory = new ConnectedNodeGeometryFactory();
        } else if (table.equals("end")) {
            this.geometryFactory = new EntityNodeGeometryFactory();
        } else if (table.equals("txt")) {
            this.geometryFactory = new TextGeometryFactory();
            this.textTypeFeature = true;
        }
    }

    private void addFileToTable(VPFFile vpfFile) {
        boolean addPrimaryKey = this.fileList.isEmpty();
        if (!this.fileList.contains(vpfFile)) {
            this.fileList.add(vpfFile);
            int inx = addPrimaryKey ? 0 : 1;
            while (inx < vpfFile.getAttributeCount()) {
                this.columns.add(vpfFile.getDescriptor(inx));
                ++inx;
            }
        }
    }

    public VPFCoverage getCoverage() {
        return this.coverage;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public List getFileList() {
        return this.fileList;
    }

    public List getJoinList() {
        return this.joinList;
    }

    public String getTypeName() {
        return this.featureType.getTypeName();
    }

    public int getAttributeCount() {
        return this.featureType.getAttributeCount();
    }

    public boolean isAbstract() {
        return this.featureType.isAbstract();
    }

    public VPFGeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public boolean equals(Object obj) {
        return this.featureType.equals(obj);
    }

    public int hashCode() {
        return this.featureType.hashCode();
    }

    public AttributeDescriptor getDescriptor(Name name) {
        return this.featureType.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(String name) {
        return this.featureType.getDescriptor(name);
    }

    public AttributeDescriptor getDescriptor(int index) {
        return this.featureType.getDescriptor(index);
    }

    public List getAttributeDescriptors() {
        return this.featureType.getAttributeDescriptors();
    }

    public AttributeType getType(Name name) {
        return this.featureType.getType(name);
    }

    public AttributeType getType(String name) {
        return this.featureType.getType(name);
    }

    public AttributeType getType(int index) {
        return this.featureType.getType(index);
    }

    public List getTypes() {
        return this.featureType.getTypes();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.featureType.getCoordinateReferenceSystem();
    }

    public GeometryDescriptor getGeometryDescriptor() {
        return this.featureType.getGeometryDescriptor();
    }

    public Class getBinding() {
        return this.featureType.getBinding();
    }

    public Collection getDescriptors() {
        return this.featureType.getDescriptors();
    }

    public boolean isInline() {
        return this.featureType.isInline();
    }

    public AttributeType getSuper() {
        return this.featureType.getSuper();
    }

    public boolean isIdentified() {
        return this.featureType.isIdentified();
    }

    public InternationalString getDescription() {
        return this.featureType.getDescription();
    }

    public Name getName() {
        return this.featureType.getName();
    }

    public int indexOf(String name) {
        return this.featureType.indexOf(name);
    }

    public int indexOf(Name name) {
        return this.featureType.indexOf(name);
    }

    public List<Filter> getRestrictions() {
        return this.featureType.getRestrictions();
    }

    public Map<Object, Object> getUserData() {
        return this.featureType.getUserData();
    }
}

