/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf.util;

import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.io.VPFDate;

public class DataUtils
implements DataTypesDefinition {
    public static byte[] toBigEndian(byte[] source) {
        byte[] result = new byte[source.length];
        int i = 0;
        while (i < source.length) {
            result[i] = source[source.length - (i + 1)];
            ++i;
        }
        return result;
    }

    public static Object decodeData(byte[] bytes, char type) {
        Object result = null;
        switch (type) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                StringBuffer sb = new StringBuffer(bytes.length);
                int i = 0;
                while (i < bytes.length) {
                    sb.append((char)bytes[i]);
                    ++i;
                }
                boolean isNull = false;
                int i2 = 0;
                while (i2 < STRING_NULL_VALUES.length) {
                    isNull |= sb.toString().trim().equalsIgnoreCase(STRING_NULL_VALUES[i2]);
                    ++i2;
                }
                if (isNull) {
                    result = null;
                    break;
                }
                result = sb.toString().trim();
                break;
            }
            case 'F': {
                result = new Float(DataUtils.decodeFloat(bytes));
                break;
            }
            case 'R': {
                result = new Double(DataUtils.decodeDouble(bytes));
                break;
            }
            case 'S': {
                result = new Short(DataUtils.decodeShort(bytes));
                break;
            }
            case 'I': {
                result = new Integer(DataUtils.decodeInt(bytes));
                break;
            }
            case 'B': 
            case 'C': 
            case 'Y': 
            case 'Z': {
                throw new RuntimeException("If this code is actually being used, replace it with equivalent code from VPFFile.");
            }
            case 'D': {
                result = new VPFDate(bytes);
                break;
            }
            case 'X': {
                break;
            }
        }
        return result;
    }

    public static void copyArrays(byte[] dest, byte[] source, int fromIdx) {
        int i = 0;
        while (i < dest.length) {
            dest[i] = source[i + fromIdx];
            ++i;
        }
    }

    public static short decodeShort(byte[] bytes) {
        short res = 0;
        int shift = 8;
        int i = 0;
        while (i < bytes.length && shift >= 0) {
            res = (short)(res | (short)(bytes[i] & 0xFF) << shift);
            shift -= 8;
            ++i;
        }
        return res;
    }

    public static int decodeInt(byte[] bytes) {
        int res = 0;
        int shift = 24;
        int i = 0;
        while (i < bytes.length && shift >= 0) {
            res |= (bytes[i] & 0xFF) << shift;
            shift -= 8;
            ++i;
        }
        return res;
    }

    public static float decodeFloat(byte[] bytes) {
        int res = 0;
        int shift = 24;
        int i = 0;
        while (i < bytes.length && shift >= 0) {
            res |= (bytes[i] & 0xFF) << shift;
            shift -= 8;
            ++i;
        }
        return Float.intBitsToFloat(res);
    }

    public static double decodeDouble(byte[] bytes) {
        long res = 0L;
        int shift = 56;
        int i = 0;
        while (i < bytes.length && shift >= 0) {
            res |= (long)(bytes[i] & 0xFF) << shift;
            shift -= 8;
            ++i;
        }
        return Double.longBitsToDouble(res);
    }

    public static int unsigByteToInt(byte b) {
        return b & 0xFF;
    }

    public static int getDataTypeSize(char type) {
        int size = -1;
        switch (type) {
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': {
                size = 1;
                break;
            }
            case 'F': {
                size = 4;
                break;
            }
            case 'R': {
                size = 8;
                break;
            }
            case 'S': {
                size = 2;
                break;
            }
            case 'I': {
                size = 4;
                break;
            }
            case 'C': {
                size = 8;
                break;
            }
            case 'B': {
                size = 16;
                break;
            }
            case 'Z': {
                size = 12;
                break;
            }
            case 'Y': {
                size = 24;
                break;
            }
            case 'D': {
                size = 20;
                break;
            }
            case 'X': {
                size = 0;
                break;
            }
            case 'K': {
                size = 1;
            }
        }
        return size;
    }

    public static boolean isNumeric(char type) {
        switch (type) {
            case 'D': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'T': 
            case 'X': {
                return false;
            }
            case 'F': 
            case 'I': 
            case 'R': 
            case 'S': {
                return true;
            }
            case 'B': 
            case 'C': 
            case 'K': 
            case 'Y': 
            case 'Z': {
                return true;
            }
        }
        return false;
    }
}

