/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.vpf;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Map;
import org.geotools.data.vpf.ifc.DataTypesDefinition;
import org.geotools.data.vpf.io.TripletId;
import org.geotools.data.vpf.util.DataUtils;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VPFColumn
implements AttributeDescriptor,
DataTypesDefinition {
    private boolean attemptLookup = false;
    private final AttributeDescriptor attribute;
    private final int elementsNumber;
    private final String narrTable;
    private final char keyType;
    private final String colDesc;
    private final String thematicIdx;
    private final char typeChar;
    private final String valDescTableName;

    public VPFColumn(String name, char type, int elementsNumber, char keyType, String colDesc, String valDescTableName, String thematicIdx, String narrTable) {
        this.typeChar = type;
        this.elementsNumber = elementsNumber;
        this.keyType = keyType;
        this.colDesc = colDesc;
        this.valDescTableName = valDescTableName;
        this.thematicIdx = thematicIdx;
        this.narrTable = narrTable;
        this.attribute = new AttributeTypeBuilder().length(this.getColumnSize()).binding(this.getColumnClass()).nillable(true).buildDescriptor(name);
    }

    public Class getColumnClass() {
        Class columnClass;
        switch (this.typeChar) {
            case 'I': {
                columnClass = Integer.class;
                break;
            }
            case 'F': {
                columnClass = Float.class;
                break;
            }
            case 'R': {
                columnClass = Double.class;
                break;
            }
            case 'B': 
            case 'C': 
            case 'Y': 
            case 'Z': {
                columnClass = Geometry.class;
                break;
            }
            case 'K': {
                columnClass = TripletId.class;
                break;
            }
            case 'S': {
                this.attemptLookup = true;
            }
            default: {
                columnClass = String.class;
            }
        }
        return columnClass;
    }

    private int getColumnSize() {
        return DataUtils.getDataTypeSize(this.typeChar) * this.elementsNumber;
    }

    public String getLocalName() {
        return this.attribute.getLocalName();
    }

    public String getNarrTable() {
        return this.narrTable;
    }

    public String getThematicIdx() {
        return this.thematicIdx;
    }

    public String getValDescTableName() {
        return this.valDescTableName;
    }

    public boolean isGeometry() {
        return this.attribute instanceof Geometry;
    }

    public boolean isNillable() {
        return this.attribute.isNillable();
    }

    public char getTypeChar() {
        return this.typeChar;
    }

    public int getElementsNumber() {
        return this.elementsNumber;
    }

    public GeometryDescriptor getGeometryAttributeType() {
        GeometryDescriptor result = null;
        if (this.isGeometry()) {
            result = (GeometryDescriptor)this.attribute;
        }
        return result;
    }

    public boolean isAttemptLookup() {
        return this.attemptLookup;
    }

    public int getMinOccurs() {
        return 1;
    }

    public int getMaxOccurs() {
        return 1;
    }

    public boolean equals(Object obj) {
        return this.attribute.equals(obj);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public AttributeType getType() {
        return this.attribute.getType();
    }

    public Name getName() {
        return this.attribute.getName();
    }

    public Object getDefaultValue() {
        return this.attribute.getDefaultValue();
    }

    public Map<Object, Object> getUserData() {
        return this.attribute.getUserData();
    }

    public PropertyType type() {
        return this.attribute.getType();
    }
}

