/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.wfs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.gml.GMLSchema;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.schema.impl.AttributeGT;
import org.geotools.xml.schema.impl.FacetGT;
import org.geotools.xml.schema.impl.SimpleTypeGT;
import org.geotools.xml.wfs.WFSBasicComplexTypes;
import org.geotools.xml.wfs.WFSCapabilitiesComplexTypes;
import org.geotools.xml.wfs.WFSTransactionComplexTypes;
import org.geotools.xml.xsi.XSISimpleTypes;

public class WFSSchema
implements Schema {
    static Logger logger = Logging.getLogger((String)"net.refractions.xml.wfs");
    private static Schema instance = new WFSSchema();
    public static URI NAMESPACE = WFSSchema.makeURI("http://www.opengis.net/wfs");
    static final Element[] elements = new Element[]{new WFSElement("GetCapabilities", (Type)WFSBasicComplexTypes.GetCapabilitiesType.getInstance()), new WFSElement("DescribeFeatureType", (Type)WFSBasicComplexTypes.DescribeFeatureTypeType.getInstance()), new WFSElement("GetFeature", (Type)WFSBasicComplexTypes.GetFeatureType.getInstance()), new WFSElement("FeatureCollection", (Type)WFSBasicComplexTypes.FeatureCollectionType.getInstance(), 1, 1, false, WFSSchema.findElement(GMLSchema.getInstance(), "_FeatureCollection")), new WFSElement("Query", (Type)WFSBasicComplexTypes.QueryType.getInstance()), new WFSElement("Abstract", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("AccessConstraints", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("Fees", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("Keywords", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("OnlineResource", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("SRS", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("Title", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("Query", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Insert", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Update", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Delete", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("Lock", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("VendorSpecificCapabilities", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("WFS_Capabilities", (Type)WFSCapabilitiesComplexTypes.WFS_CapabilitiesType.getInstance()), new WFSElement("GML2", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("GML2-GZIP", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("XMLSCHEMA", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("GetFeatureWithLock", (Type)WFSTransactionComplexTypes.GetFeatureWithLockType.getInstance()), new WFSElement("LockFeature", (Type)WFSTransactionComplexTypes.LockFeatureType.getInstance()), new WFSElement("Transaction", (Type)WFSTransactionComplexTypes.TransactionType.getInstance()), new WFSElement("WFS_TransactionResponse", (Type)WFSTransactionComplexTypes.WFS_TransactionResponseType.getInstance()), new WFSElement("WFS_LockFeatureResponse", (Type)WFSTransactionComplexTypes.WFS_LockFeatureResponseType.getInstance()), new WFSElement("LockId", (Type)XSISimpleTypes.String.getInstance()), new WFSElement("Insert", (Type)WFSTransactionComplexTypes.InsertElementType.getInstance()), new WFSElement("Update", (Type)WFSTransactionComplexTypes.UpdateElementType.getInstance()), new WFSElement("Delete", (Type)WFSTransactionComplexTypes.DeleteElementType.getInstance()), new WFSElement("Native", (Type)WFSTransactionComplexTypes.NativeType.getInstance()), new WFSElement("Property", (Type)WFSTransactionComplexTypes.PropertyType.getInstance()), new WFSElement("SUCCESS", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("FAILED", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance()), new WFSElement("PARTIAL", (Type)WFSCapabilitiesComplexTypes.EmptyType.getInstance())};
    static final ComplexType[] complexTypes = new ComplexType[]{WFSBasicComplexTypes.GetCapabilitiesType.getInstance(), WFSBasicComplexTypes.DescribeFeatureTypeType.getInstance(), WFSBasicComplexTypes.GetFeatureType.getInstance(), WFSBasicComplexTypes.QueryType.getInstance(), WFSBasicComplexTypes.FeatureCollectionType.getInstance(), WFSCapabilitiesComplexTypes.WFS_CapabilitiesType.getInstance(), WFSCapabilitiesComplexTypes.ServiceType.getInstance(), WFSCapabilitiesComplexTypes.CapabilityType.getInstance(), WFSCapabilitiesComplexTypes.FeatureTypeListType.getInstance(), WFSCapabilitiesComplexTypes.RequestType.getInstance(), WFSTransactionComplexTypes.TransactionType.getInstance(), WFSCapabilitiesComplexTypes.LockFeatureTypeType.getInstance(), WFSCapabilitiesComplexTypes.DCPTypeType.getInstance(), WFSCapabilitiesComplexTypes.FeatureTypeType.getInstance(), WFSCapabilitiesComplexTypes.GetType.getInstance(), WFSCapabilitiesComplexTypes.HTTPType.getInstance(), WFSCapabilitiesComplexTypes.LatLongBoundingBoxType.getInstance(), WFSCapabilitiesComplexTypes.MetadataURLType.getInstance(), WFSCapabilitiesComplexTypes.OperationsType.getInstance(), WFSCapabilitiesComplexTypes.PostType.getInstance(), WFSCapabilitiesComplexTypes.ResultFormatType.getInstance(), WFSCapabilitiesComplexTypes.SchemaDescriptionLanguageType.getInstance(), WFSCapabilitiesComplexTypes.EmptyType.getInstance(), WFSTransactionComplexTypes.GetFeatureWithLockType.getInstance(), WFSTransactionComplexTypes.LockFeatureType.getInstance(), WFSTransactionComplexTypes.LockType.getInstance(), WFSTransactionComplexTypes.InsertElementType.getInstance(), WFSTransactionComplexTypes.UpdateElementType.getInstance(), WFSTransactionComplexTypes.DeleteElementType.getInstance(), WFSTransactionComplexTypes.NativeType.getInstance(), WFSTransactionComplexTypes.PropertyType.getInstance(), WFSTransactionComplexTypes.WFS_LockFeatureResponseType.getInstance(), WFSTransactionComplexTypes.FeaturesLockedType.getInstance(), WFSTransactionComplexTypes.FeaturesNotLockedType.getInstance(), WFSTransactionComplexTypes.WFS_TransactionResponseType.getInstance(), WFSTransactionComplexTypes.TransactionResultType.getInstance(), WFSTransactionComplexTypes.InsertResultType.getInstance(), WFSTransactionComplexTypes.StatusType.getInstance()};
    static final SimpleType[] simpleTypes = new SimpleType[]{new SimpleTypeGT(null, "AllSomeType", NAMESPACE, 4, new SimpleType[]{XSISimpleTypes.String.getInstance()}, new Facet[]{new FacetGT(1, "ALL"), new FacetGT(1, "SOME")}, 0)};

    private static URI makeURI(String s) {
        try {
            return new URI(s);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public static Schema getInstance() {
        return instance;
    }

    private static Element findElement(Schema s, String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        Element[] elems = s.getElements();
        if (elems == null) {
            return null;
        }
        for (int i = 0; i < elems.length; ++i) {
            if (!name.equals(elems[i].getName())) continue;
            return elems[i];
        }
        return null;
    }

    public AttributeGroup[] getAttributeGroups() {
        return new AttributeGroup[0];
    }

    public Attribute[] getAttributes() {
        return new Attribute[0];
    }

    public int getBlockDefault() {
        return 0;
    }

    public ComplexType[] getComplexTypes() {
        return complexTypes;
    }

    public Element[] getElements() {
        return elements;
    }

    public int getFinalDefault() {
        return 0;
    }

    public Group[] getGroups() {
        return new Group[0];
    }

    public String getId() {
        return null;
    }

    public Schema[] getImports() {
        return new Schema[]{GMLSchema.getInstance(), FilterSchema.getInstance()};
    }

    public SimpleType[] getSimpleTypes() {
        return simpleTypes;
    }

    public URI getTargetNamespace() {
        return NAMESPACE;
    }

    public URI getURI() {
        try {
            return new URI("http://www.opengis.net/wfs");
        }
        catch (URISyntaxException e) {
            logger.warning(e.toString());
            return null;
        }
    }

    public String getVersion() {
        return "1.0.0";
    }

    public boolean includesURI(URI uri) {
        return true;
    }

    public boolean isAttributeFormDefault() {
        return false;
    }

    public boolean isElementFormDefault() {
        return true;
    }

    public String getPrefix() {
        return "wfs";
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    static class WFSAttribute
    extends AttributeGT {
        private WFSAttribute() {
            super(null, null, NAMESPACE, null, 0, null, null, false);
        }

        public WFSAttribute(String name, SimpleType simpleType) {
            super(null, name, NAMESPACE, simpleType, 0, null, null, false);
        }

        public WFSAttribute(String name, SimpleType simpleType, int use) {
            super(null, name, NAMESPACE, simpleType, use, null, null, false);
        }

        public WFSAttribute(String name, SimpleType simpleType, int use, String def) {
            super(null, name, NAMESPACE, simpleType, use, def, null, false);
        }
    }

    static class WFSElement
    implements Element {
        boolean abstracT = false;
        int max;
        int min;
        String name;
        Type type;
        Element substitutionGroup;

        private WFSElement() {
        }

        public WFSElement(String name, Type type) {
            this.max = 1;
            this.min = 1;
            this.name = name;
            this.type = type;
            this.substitutionGroup = null;
        }

        public WFSElement(String name, Type type, int min, int max, boolean abstracT, Element substitutionGroup) {
            this.abstracT = abstracT;
            this.max = max;
            this.min = min;
            this.name = name;
            this.type = type;
            this.substitutionGroup = substitutionGroup;
        }

        public WFSElement(Element element, int min, int max) {
            this.abstracT = element.isAbstract();
            this.max = max;
            this.min = min;
            this.name = element.getName();
            this.type = element.getType();
            this.substitutionGroup = element.getSubstitutionGroup();
        }

        public Element findChildElement(String name1) {
            if (this.name != null && this.name.equals(name1)) {
                return this;
            }
            return null;
        }

        public int getGrouping() {
            return 1;
        }

        public boolean isAbstract() {
            return this.abstracT;
        }

        public int getBlock() {
            return 0;
        }

        public String getDefault() {
            return null;
        }

        public int getFinal() {
            return 0;
        }

        public String getFixed() {
            return null;
        }

        public boolean isForm() {
            return false;
        }

        public String getId() {
            return null;
        }

        public int getMaxOccurs() {
            return this.max;
        }

        public int getMinOccurs() {
            return this.min;
        }

        public String getName() {
            return this.name;
        }

        public boolean isNillable() {
            return false;
        }

        public Element getSubstitutionGroup() {
            return this.substitutionGroup;
        }

        public Type getType() {
            return this.type;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        public Element findChildElement(String localName, URI namespaceURI) {
            if (this.name != null && this.name.equals(localName) && this.getNamespace().equals(namespaceURI)) {
                return this;
            }
            return null;
        }
    }

    static abstract class WFSComplexType
    implements ComplexType {
        WFSComplexType() {
        }

        public int getBlock() {
            return 0;
        }

        public int getFinal() {
            return 0;
        }

        public String getId() {
            return null;
        }

        public boolean isMixed() {
            return false;
        }

        public URI getNamespace() {
            return NAMESPACE;
        }

        static WFSComplexType getInstance() {
            return null;
        }

        public boolean isDerived() {
            return false;
        }

        public Type getParent() {
            return null;
        }

        public boolean cache(Element element, Map hints) {
            return true;
        }

        public String getAnyAttributeNameSpace() {
            return null;
        }

        public Element findChildElement(String name) {
            return this.getChild() == null ? null : this.getChild().findChildElement(name);
        }

        public boolean isAbstract() {
            return false;
        }
    }
}

