/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.oracle;

import java.io.IOException;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.oracle.OracleDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.SQLDialect;

public class OracleNGDataStoreFactory
extends JDBCDataStoreFactory {
    private static final String JDBC_PATH = "jdbc:oracle:thin:@";
    public static final DataAccessFactory.Param DBTYPE = new DataAccessFactory.Param("dbtype", String.class, "Type", true, (Object)"oracle");
    public static final DataAccessFactory.Param PORT = new DataAccessFactory.Param("port", Integer.class, "Port", false, (Object)1521);
    public static final DataAccessFactory.Param HOST = new DataAccessFactory.Param("host", String.class, "Host", false, (Object)"localhost");
    public static final DataAccessFactory.Param DATABASE = new DataAccessFactory.Param("database", String.class, "Database", true);
    public static final DataAccessFactory.Param ESTIMATED_EXTENTS = new DataAccessFactory.Param("Estimated extends", Boolean.class, "Use the spatial index information to quickly get an estimate of the data bounds", false, (Object)Boolean.TRUE);
    public static final DataAccessFactory.Param LOOSEBBOX = new DataAccessFactory.Param("Loose bbox", Boolean.class, "Perform only primary filter on bbox", false, (Object)Boolean.TRUE);

    protected SQLDialect createSQLDialect(JDBCDataStore dataStore) {
        return new OracleDialect(dataStore);
    }

    protected String getDatabaseID() {
        return (String)OracleNGDataStoreFactory.DBTYPE.sample;
    }

    public String getDisplayName() {
        return "Oracle NG";
    }

    public String getDescription() {
        return "Oracle Database";
    }

    protected String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    protected boolean checkDBType(Map params) {
        if (super.checkDBType(params)) {
            try {
                Class.forName("org.geotools.data.oracle.OracleDataStoreFactory");
                return false;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
        }
        return this.checkDBType(params, "Oracle");
    }

    protected JDBCDataStore createDataStoreInternal(JDBCDataStore dataStore, Map params) throws IOException {
        if (dataStore.getDatabaseSchema() != null) {
            dataStore.setDatabaseSchema(dataStore.getDatabaseSchema().toUpperCase());
        }
        OracleDialect dialect = (OracleDialect)dataStore.getSQLDialect();
        Boolean loose = (Boolean)LOOSEBBOX.lookUp(params);
        dialect.setLooseBBOXEnabled(loose == null || Boolean.TRUE.equals(loose));
        Boolean estimated = (Boolean)ESTIMATED_EXTENTS.lookUp(params);
        dialect.setEstimatedExtentsEnabled(estimated == null || Boolean.TRUE.equals(estimated));
        dataStore.setFetchSize(200);
        return dataStore;
    }

    protected String getJDBCUrl(Map params) throws IOException {
        String db = (String)DATABASE.lookUp(params);
        String host = (String)HOST.lookUp(params);
        Integer port = (Integer)PORT.lookUp(params);
        if (db.startsWith("(")) {
            return JDBC_PATH + db;
        }
        if (db.startsWith("/") && host != null && port != null) {
            return "jdbc:oracle:thin:@//" + host + ":" + port + db;
        }
        if (host != null && port != null) {
            return JDBC_PATH + host + ":" + port + ":" + db;
        }
        throw new IOException("Unable to properly compose the JDBC URL string, some parameters as host and port may be null !");
    }

    protected void setupParameters(Map parameters) {
        super.setupParameters(parameters);
        parameters.put(OracleNGDataStoreFactory.LOOSEBBOX.key, LOOSEBBOX);
        parameters.put(OracleNGDataStoreFactory.ESTIMATED_EXTENTS.key, ESTIMATED_EXTENTS);
        parameters.put(OracleNGDataStoreFactory.MAX_OPEN_PREPARED_STATEMENTS.key, MAX_OPEN_PREPARED_STATEMENTS);
        parameters.put(OracleNGDataStoreFactory.PORT.key, PORT);
        parameters.put(OracleNGDataStoreFactory.HOST.key, HOST);
        parameters.put(OracleNGDataStoreFactory.DATABASE.key, DATABASE);
        parameters.put(OracleNGDataStoreFactory.DBTYPE.key, DBTYPE);
    }

    protected String getValidationQuery() {
        return "select sysdate from dual";
    }
}

