/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.FilterToSqlHelper;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.filter.FilterCapabilities;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class PostgisFilterToSQL
extends FilterToSQL {
    FilterToSqlHelper helper = new FilterToSqlHelper(this);

    public PostgisFilterToSQL(PostGISDialect dialect) {
    }

    public boolean isLooseBBOXEnabled() {
        return this.helper.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.helper.looseBBOXEnabled = looseBBOXEnabled;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Object typename;
        Geometry geom = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (geom instanceof LinearRing) {
            geom = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
        }
        if ("geography".equals(typename = this.currentGeometry.getUserData().get("org.geotools.jdbc.nativeTypeName"))) {
            this.out.write("ST_GeogFromText('");
            this.out.write(geom.toText());
            this.out.write("')");
        } else {
            this.out.write("ST_GeomFromText('");
            this.out.write(geom.toText());
            if (this.currentSRID == null && this.currentGeometry != null) {
                this.out.write("', ST_SRID(\"" + this.currentGeometry.getLocalName() + "\"))");
            } else {
                this.out.write("', " + this.currentSRID + ")");
            }
        }
    }

    protected FilterCapabilities createFilterCapabilities() {
        return FilterToSqlHelper.createFilterCapabilities();
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }

    GeometryDescriptor getCurrentGeometry() {
        return this.currentGeometry;
    }
}

