/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.PostgisFilterToSQL;
import org.geotools.data.postgis.WKBAttributeIO;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostGISDialect
extends BasicSQLDialect {
    static final Map<String, Class> TYPE_TO_CLASS_MAP = new HashMap<String, Class>(){
        {
            this.put("GEOMETRY", Geometry.class);
            this.put("POINT", Point.class);
            this.put("POINTM", Point.class);
            this.put("LINESTRING", LineString.class);
            this.put("LINESTRINGM", LineString.class);
            this.put("POLYGON", Polygon.class);
            this.put("POLYGONM", Polygon.class);
            this.put("MULTIPOINT", MultiPoint.class);
            this.put("MULTIPOINTM", MultiPoint.class);
            this.put("MULTILINESTRING", MultiLineString.class);
            this.put("MULTILINESTRINGM", MultiLineString.class);
            this.put("MULTIPOLYGON", MultiPolygon.class);
            this.put("MULTIPOLYGONM", MultiPolygon.class);
            this.put("GEOMETRYCOLLECTION", GeometryCollection.class);
            this.put("GEOMETRYCOLLECTIONM", GeometryCollection.class);
        }
    };
    static final Map<Class, String> CLASS_TO_TYPE_MAP = new HashMap<Class, String>(){
        {
            this.put(Geometry.class, "GEOMETRY");
            this.put(Point.class, "POINT");
            this.put(LineString.class, "LINESTRING");
            this.put(Polygon.class, "POLYGON");
            this.put(MultiPoint.class, "MULTIPOINT");
            this.put(MultiLineString.class, "MULTILINESTRING");
            this.put(MultiPolygon.class, "MULTIPOLYGON");
            this.put(GeometryCollection.class, "GEOMETRYCOLLECTION");
        }
    };
    boolean looseBBOXEnabled = false;
    boolean estimatedExtentsEnabled = false;
    ThreadLocal<WKBAttributeIO> wkbReader = new ThreadLocal();

    public PostGISDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public boolean isLooseBBOXEnabled() {
        return this.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.looseBBOXEnabled = looseBBOXEnabled;
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        if (tableName.equals("geometry_columns")) {
            return false;
        }
        return !tableName.startsWith("spatial_ref_sys");
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        WKBAttributeIO reader = this.wkbReader.get();
        if (reader == null) {
            reader = new WKBAttributeIO(factory);
            this.wkbReader.set(reader);
        }
        return (Geometry)reader.read(rs, column);
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, int column, GeometryFactory factory, Connection cx) throws IOException, SQLException {
        WKBAttributeIO reader = this.wkbReader.get();
        if (reader == null) {
            reader = new WKBAttributeIO(factory);
            this.wkbReader.set(reader);
        }
        return (Geometry)reader.read(rs, column);
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, int srid, StringBuffer sql) {
        CoordinateReferenceSystem crs = gatt.getCoordinateReferenceSystem();
        int dimensions = crs == null ? 2 : crs.getCoordinateSystem().getDimension();
        sql.append("encode(");
        if (dimensions > 2) {
            sql.append("asEWKB(");
            this.encodeColumnName(gatt.getLocalName(), sql);
        } else {
            sql.append("asBinary(");
            sql.append("force_2d(");
            this.encodeColumnName(gatt.getLocalName(), sql);
            sql.append(")");
        }
        sql.append(",'XDR'),'base64')");
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        if (this.estimatedExtentsEnabled) {
            sql.append("estimated_extent(");
            sql.append("'" + tableName + "','" + geometryColumn + "'))));");
        } else {
            sql.append("AsText(force_2d(Envelope(");
            sql.append("Extent(\"" + geometryColumn + "\"))))");
        }
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        try {
            String envelope = rs.getString(column);
            if (envelope != null) {
                return new WKTReader().read(envelope).getEnvelopeInternal();
            }
            return new Envelope();
        }
        catch (ParseException e) {
            throw (IOException)new IOException("Error occurred parsing the bounds WKT").initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        int SCHEMA_NAME = 2;
        int TABLE_NAME = 3;
        int COLUMN_NAME = 4;
        int TYPE_NAME = 6;
        if (!columnMetaData.getString(6).equals("geometry")) {
            return null;
        }
        String tableName = columnMetaData.getString(3);
        String columnName = columnMetaData.getString(4);
        String schemaName = columnMetaData.getString(2);
        Object conn = null;
        Statement statement = null;
        ResultSet result = null;
        String gType = null;
        try {
            String sqlStatement = "SELECT TYPE FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOMETRY_COLUMN = '" + columnName + "'";
            LOGGER.log(Level.FINE, "Geometry type check; {0} ", sqlStatement);
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                gType = result.getString(1);
            }
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            throw throwable;
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        Class<Geometry> geometryClass = TYPE_TO_CLASS_MAP.get(gType);
        if (geometryClass == null) {
            geometryClass = Geometry.class;
        }
        return geometryClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Object conn = null;
        Statement statement = null;
        ResultSet result = null;
        Integer srid = null;
        try {
            if (schemaName == null) {
                schemaName = "public";
            }
            String sqlStatement = "SELECT SRID FROM GEOMETRY_COLUMNS WHERE F_TABLE_SCHEMA = '" + schemaName + "' " + "AND F_TABLE_NAME = '" + tableName + "' " + "AND F_GEOMETRY_COLUMN = '" + columnName + "'";
            LOGGER.log(Level.FINE, "Geometry type check; {0} ", sqlStatement);
            statement = cx.createStatement();
            result = statement.executeQuery(sqlStatement);
            if (result.next()) {
                srid = result.getInt(1);
            }
        }
        catch (Throwable throwable) {
            this.dataStore.closeSafe(result);
            this.dataStore.closeSafe(statement);
            throw throwable;
        }
        this.dataStore.closeSafe(result);
        this.dataStore.closeSafe(statement);
        return srid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSequenceForColumn(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT pg_get_serial_sequence('\"";
            if (schemaName != null && !"".equals(schemaName)) {
                sql = sql + schemaName + "\".\"";
            }
            sql = sql + tableName + "\"', '" + columnName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    String string = rs.getString(1);
                    return string;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNextSequenceValue(String schemaName, String sequenceName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT nextval('" + sequenceName + "')";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public boolean lookupGeneratedValuesPostInsert() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getLastAutoGeneratedValue(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        Statement st = cx.createStatement();
        try {
            String sql = "SELECT lastval()";
            this.dataStore.getLogger().fine(sql);
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Long l = rs.getLong(1);
                    return l;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
    }

    public void registerSqlTypeNameToClassMappings(Map<String, Class<?>> mappings) {
        super.registerSqlTypeNameToClassMappings(mappings);
        mappings.put("geometry", Geometry.class);
    }

    public void registerSqlTypeToSqlTypeNameOverrides(Map<Integer, String> overrides) {
        overrides.put(12, "VARCHAR");
        overrides.put(16, "BOOL");
    }

    public String getGeometryTypeName(Integer type) {
        return "geometry";
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(column, sql);
        sql.append(" SERIAL PRIMARY KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postCreateTable(String schemaName, SimpleFeatureType featureType, Connection cx) throws SQLException {
        schemaName = schemaName != null ? schemaName : "public";
        String tableName = featureType.getName().getLocalPart();
        Statement st = null;
        try {
            st = cx.createStatement();
            for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                if (!(att instanceof GeometryDescriptor)) continue;
                GeometryDescriptor gd = (GeometryDescriptor)att;
                int srid = -1;
                if (gd.getUserData().get("nativeSRID") != null) {
                    srid = (Integer)gd.getUserData().get("nativeSRID");
                } else if (gd.getCoordinateReferenceSystem() != null) {
                    try {
                        Integer result = CRS.lookupEpsgCode((CoordinateReferenceSystem)gd.getCoordinateReferenceSystem(), (boolean)true);
                        if (result != null) {
                            srid = result;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Error looking up the epsg code for metadata insertion, assuming -1", e);
                    }
                }
                int dimensions = 2;
                String geomType = CLASS_TO_TYPE_MAP.get(gd.getType().getBinding());
                if (geomType == null) {
                    geomType = "GEOMETRY";
                }
                String sql = "DELETE FROM GEOMETRY_COLUMNS WHERE f_table_catalog='' AND f_table_schema = '" + schemaName + "'" + " AND f_table_name = '" + tableName + "'" + " AND f_geometry_column = '" + gd.getLocalName() + "'";
                LOGGER.fine(sql);
                st.execute(sql);
                sql = "INSERT INTO GEOMETRY_COLUMNS VALUES ('','" + schemaName + "'," + "'" + tableName + "'," + "'" + gd.getLocalName() + "'," + dimensions + "," + srid + "," + "'" + geomType + "')";
                LOGGER.fine(sql);
                st.execute(sql);
                if (srid > -1) {
                    sql = "ALTER TABLE \"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_srid_" + gd.getLocalName() + "\"" + " CHECK (SRID(" + "\"" + gd.getLocalName() + "\"" + ") = " + srid + ")";
                    LOGGER.fine(sql);
                    st.execute(sql);
                }
                sql = "ALTER TABLE \"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_dims_" + gd.getLocalName() + "\"" + " CHECK (ndims(\"" + gd.getLocalName() + "\")" + " = 2)";
                LOGGER.fine(sql);
                st.execute(sql);
                if (!geomType.equals("GEOMETRY")) {
                    sql = "ALTER TABLE \"" + tableName + "\"" + " ADD CONSTRAINT \"enforce_geotype_" + gd.getLocalName() + "\"" + " CHECK (geometrytype(" + "\"" + gd.getLocalName() + "\"" + ") = '" + geomType + "'::text " + "OR \"" + gd.getLocalName() + "\"" + " IS NULL)";
                    LOGGER.fine(sql);
                    st.execute(sql);
                }
                sql = "CREATE INDEX \"spatial_" + tableName + "_" + gd.getLocalName().toLowerCase() + "\"" + " ON " + "\"" + tableName + "\"" + " USING GIST (" + "\"" + gd.getLocalName() + "\"" + ")";
                LOGGER.fine(sql);
                st.execute(sql);
            }
            cx.commit();
        }
        finally {
            this.dataStore.closeSafe(st);
        }
    }

    public void encodeGeometryValue(Geometry value, int srid, StringBuffer sql) throws IOException {
        if (value == null) {
            sql.append("NULL");
        } else {
            if (value instanceof LinearRing) {
                value = value.getFactory().createLineString(((LinearRing)value).getCoordinateSequence());
            }
            sql.append("GeomFromText('" + value.toText() + "', " + srid + ")");
        }
    }

    public FilterToSQL createFilterToSQL() {
        PostgisFilterToSQL sql = new PostgisFilterToSQL(this);
        sql.setLooseBBOXEnabled(this.looseBBOXEnabled);
        return sql;
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit > 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT " + limit);
            if (offset > 0) {
                sql.append(" OFFSET " + offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET " + offset);
        }
    }
}

