/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.postgis;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LinearRing;
import java.io.IOException;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.postgis.FilterToSqlHelper;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.filter.FilterCapabilities;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;

public class PostgisFilterToSQL
extends FilterToSQL {
    FilterToSqlHelper helper = new FilterToSqlHelper(this);
    Integer currentSRID;

    public PostgisFilterToSQL(PostGISDialect dialect) {
    }

    public boolean isLooseBBOXEnabled() {
        return this.helper.looseBBOXEnabled;
    }

    public void setLooseBBOXEnabled(boolean looseBBOXEnabled) {
        this.helper.looseBBOXEnabled = looseBBOXEnabled;
    }

    protected void visitLiteralGeometry(Literal expression) throws IOException {
        Geometry geom = (Geometry)this.evaluateLiteral(expression, Geometry.class);
        if (geom instanceof LinearRing) {
            geom = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
        }
        this.out.write("GeomFromText('");
        this.out.write(geom.toText());
        this.out.write("', " + this.currentSRID + ")");
    }

    protected FilterCapabilities createFilterCapabilities() {
        PostgisFilterToSQL postgisFilterToSQL = this;
        return postgisFilterToSQL.helper.createFilterCapabilities();
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, Object extraData) {
        AttributeDescriptor descriptor;
        Literal geometry;
        PropertyName property;
        if (filter == null) {
            throw new NullPointerException("Filter to be encoded cannot be null");
        }
        if (!(filter instanceof BinaryComparisonOperator)) {
            throw new IllegalArgumentException("This filter is not a binary comparison, can't do SDO relate against it: " + filter.getClass());
        }
        BinaryComparisonOperator op = (BinaryComparisonOperator)filter;
        if (op.getExpression1() instanceof PropertyName && op.getExpression2() instanceof Literal) {
            property = (PropertyName)op.getExpression1();
            geometry = (Literal)op.getExpression2();
        } else if (op.getExpression2() instanceof PropertyName && op.getExpression1() instanceof Literal) {
            property = (PropertyName)op.getExpression2();
            geometry = (Literal)op.getExpression1();
        } else {
            throw new IllegalArgumentException("Can only encode spatial filters that do compare a property name and a geometry");
        }
        this.currentSRID = null;
        if (this.featureType != null && (descriptor = (AttributeDescriptor)property.evaluate((Object)this.featureType)) instanceof GeometryDescriptor) {
            this.currentSRID = (Integer)descriptor.getUserData().get("nativeSRID");
        }
        return this.visitBinarySpatialOperator(filter, property, geometry, filter.getExpression1() instanceof Literal, extraData);
    }

    protected Object visitBinarySpatialOperator(BinarySpatialOperator filter, PropertyName property, Literal geometry, boolean swapped, Object extraData) {
        this.helper.out = this.out;
        return this.helper.visitBinarySpatialOperator(filter, property, geometry, swapped, extraData);
    }
}

