/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InsertSourceTag {
    private final Pattern findSVNLine = Pattern.compile(".+\\/(trunk|tags|branches)\\/.*\\.java");
    private final Pattern findCommentStart = Pattern.compile("^\\s*\\Q/**\\E");
    private final Pattern findCommentEnd = Pattern.compile("\\Q*/\\E");
    private final Pattern findSourceTag = Pattern.compile("^(\\s|\\*)*\\Q@source\\E");
    private final Pattern findVersionTag = Pattern.compile("^(\\s|\\*)*\\Q@version\\E");
    private final Pattern findClass = Pattern.compile("\\s*public[a-zA-Z\\s]+(class|interface)");
    private final String lineSeparator = System.getProperty("line.separator", "\n");

    public static void main(String[] args) {
        File file;
        if (args.length == 0) {
            System.out.println("usage: InsertSourceTag fileOrDirName");
        }
        if (!(file = new File(args[0])).exists()) {
            System.out.println("Can't find " + file);
            return;
        }
        InsertSourceTag me = new InsertSourceTag();
        me.process(file);
    }

    private void process(File file) {
        block4: {
            block3: {
                if (!file.isDirectory()) break block3;
                for (File child : file.listFiles()) {
                    this.process(child);
                }
                break block4;
            }
            if (!file.getName().endsWith(".java")) break block4;
            try {
                System.out.println(file.getPath());
                this.processFile(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }
    }

    private boolean processFile(File file) throws FileNotFoundException, IOException {
        String text;
        ArrayList<String> buffer = new ArrayList<String>();
        boolean inCommentBlock = false;
        boolean nonEmptyLines = false;
        boolean completedSearch = false;
        int commentStartLine = -1;
        int commentEndLine = -1;
        int sourceTagLine = -1;
        Matcher matcher = null;
        matcher = this.findSVNLine.matcher(file.getAbsolutePath());
        if (!matcher.matches()) {
            return false;
        }
        int pos = matcher.start(1);
        StringBuilder sb = new StringBuilder(" * @source $URL: ");
        sb.append("http://svn.somewhere.foo/org/geotools/");
        sb.append(file.getAbsolutePath().substring(pos));
        sb.append(" $");
        String sourceTagText = sb.toString();
        LineNumberReader reader = new LineNumberReader(new FileReader(file));
        reader.setLineNumber(-1);
        while ((text = reader.readLine()) != null) {
            buffer.add(text);
            if (completedSearch) continue;
            if (inCommentBlock) {
                matcher = this.findCommentEnd.matcher(text);
                if (!matcher.find()) continue;
                inCommentBlock = false;
                commentEndLine = reader.getLineNumber();
                continue;
            }
            matcher = this.findCommentStart.matcher(text);
            if (matcher.find()) {
                inCommentBlock = true;
                nonEmptyLines = false;
                commentStartLine = reader.getLineNumber();
                continue;
            }
            matcher = this.findClass.matcher(text);
            if (matcher.find()) {
                int i;
                if (commentStartLine < 0) {
                    return false;
                }
                if (nonEmptyLines) {
                    return false;
                }
                for (i = commentStartLine; i <= commentEndLine; ++i) {
                    matcher = this.findSourceTag.matcher((CharSequence)buffer.get(i));
                    if (!matcher.find()) continue;
                    return false;
                }
                for (i = commentStartLine; i <= commentEndLine; ++i) {
                    matcher = this.findVersionTag.matcher((CharSequence)buffer.get(i));
                    if (!matcher.find()) continue;
                    sourceTagLine = i;
                    break;
                }
                if (sourceTagLine < 0) {
                    sourceTagLine = commentEndLine;
                }
                completedSearch = true;
                continue;
            }
            if (text.trim().length() <= 0) continue;
            nonEmptyLines = true;
        }
        reader.close();
        if (completedSearch) {
            return this.writeFile(file, buffer, sourceTagLine, sourceTagText);
        }
        return false;
    }

    private boolean writeFile(File file, List<String> buffer, int sourceTagLine, String sourceTag) throws IOException {
        FileWriter writer = new FileWriter(file);
        for (int i = 0; i < buffer.size(); ++i) {
            if (i == sourceTagLine) {
                writer.write(" *" + this.lineSeparator);
                writer.write(sourceTag);
                writer.write(this.lineSeparator);
            }
            writer.write(buffer.get(i));
            writer.write(this.lineSeparator);
        }
        writer.close();
        return true;
    }
}

