/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.project.MavenProject;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.util.XSDSchemaLocationResolver;
import org.eclipse.xsd.util.XSDSchemaLocator;
import org.geotools.xml.Schemas;
import org.geotools.xml.XSD;

public abstract class AbstractGeneratorMojo
extends AbstractMojo {
    protected File schemaLocation;
    protected File schemaSourceDirectory;
    protected File[] schemaLookupDirectories;
    protected String destinationPackage;
    protected File outputDirectory;
    protected File sourceOutputDirectory;
    protected File testOutputDirectory;
    protected boolean overwriteExistingFiles;
    protected String[] includes;
    protected String targetPrefix;
    MavenProject project;
    ArtifactRepository localRepository;
    List remoteRepositories;
    ArtifactFactory artifactFactory;
    ArtifactResolver artifactResolver;
    ArtifactMetadataSource artifactMetadataSource;
    List classpathElements;
    boolean includeGML;

    protected XSDSchema schema() {
        this.getLog().info((CharSequence)this.artifactFactory.toString());
        if (!this.schemaSourceDirectory.exists()) {
            this.getLog().error((CharSequence)(this.schemaSourceDirectory.getAbsolutePath() + " does not exist"));
            return null;
        }
        if (!this.schemaLocation.exists()) {
            this.schemaLocation = new File(this.schemaSourceDirectory, this.schemaLocation.getName());
            if (!this.schemaLocation.exists()) {
                this.getLog().error((CharSequence)("Could not locate schema: " + this.schemaLocation.getName()));
                return null;
            }
        }
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        if (this.includeGML) {
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-gml2", "2.7-SNAPSHOT", "compile", "jar"));
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-gml3", "2.7-SNAPSHOT", "compile", "jar"));
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-filter", "2.7-SNAPSHOT", "compile", "jar"));
            artifacts.add(this.artifactFactory.createArtifact("org.geotools", "gt2-xml-sld", "2.7-SNAPSHOT", "compile", "jar"));
        }
        HashSet<URL> urls = new HashSet<URL>();
        for (Artifact artifact : artifacts) {
            this.getLog().debug((CharSequence)("Attempting to dynamically resolve: " + artifact));
            try {
                Set resolvedArtifacts = this.project.createArtifacts(this.artifactFactory, null, null);
                ArtifactResolutionResult result = this.artifactResolver.resolveTransitively(resolvedArtifacts, artifact, this.remoteRepositories, this.localRepository, this.artifactMetadataSource);
                resolvedArtifacts = result.getArtifacts();
                for (Artifact resolvedArtifact : resolvedArtifacts) {
                    urls.add(resolvedArtifact.getFile().toURI().toURL());
                }
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to resolve " + artifact.getId()), (Throwable)e);
            }
        }
        URLClassLoader ext = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        StringBuffer sb = new StringBuffer();
        sb.append("Using following classpath for XSD lookup: ");
        Iterator u = urls.iterator();
        while (u.hasNext()) {
            sb.append(u.next().toString());
        }
        this.getLog().debug((CharSequence)sb.toString());
        final ArrayList<Object> xsds = new ArrayList<Object>();
        xsds.add("org.geotools.xml.XML");
        xsds.add("org.geotools.xlink.XLINK");
        if (this.includeGML) {
            xsds.add("org.geotools.gml2.GML");
            xsds.add("org.geotools.gml3.GML");
            xsds.add("org.geotools.filter.v1_0.OGC");
            xsds.add("org.geotools.filter.v1_1.OGC");
        }
        for (int i = 0; i < xsds.size(); ++i) {
            String className = (String)xsds.get(i);
            try {
                Class<?> clazz = ext.loadClass(className);
                Method m = clazz.getMethod("getInstance", null);
                Object xsd = m.invoke(null, null);
                xsds.set(i, xsd);
                continue;
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Unable to load " + className));
                this.getLog().debug((Throwable)e);
                xsds.set(i, null);
            }
        }
        XSDSchemaLocator locator = new XSDSchemaLocator(){

            public XSDSchema locateSchema(XSDSchema schema, String namespaceURI, String rawSchemaLocationURI, String resolvedSchemaLocationURI) {
                for (XSD xsd : xsds) {
                    if (xsd == null || !xsd.getNamespaceURI().equals(namespaceURI)) continue;
                    try {
                        return xsd.getSchema();
                    }
                    catch (IOException e) {
                        AbstractGeneratorMojo.this.getLog().warn((CharSequence)("Error occured locating schema: " + namespaceURI), (Throwable)e);
                    }
                }
                AbstractGeneratorMojo.this.getLog().warn((CharSequence)("Could not locate schema for: " + namespaceURI));
                return null;
            }
        };
        XSDSchemaLocationResolver locationResolver = new XSDSchemaLocationResolver(){

            public String resolveSchemaLocation(XSDSchema schema, String namespaceURI, String schemaLocation) {
                if (schemaLocation == null) {
                    AbstractGeneratorMojo.this.getLog().warn((CharSequence)("Null location for " + namespaceURI));
                    return null;
                }
                File file = new File(schemaLocation);
                if (file.exists()) {
                    AbstractGeneratorMojo.this.getLog().debug((CharSequence)("Resolving " + schemaLocation + " to " + schemaLocation));
                    return schemaLocation;
                }
                String fileName = new File(schemaLocation).getName();
                file = new File(AbstractGeneratorMojo.this.schemaSourceDirectory, fileName);
                if (file.exists()) {
                    AbstractGeneratorMojo.this.getLog().debug((CharSequence)("Resolving " + schemaLocation + " to " + file.getAbsolutePath()));
                    return file.getAbsolutePath();
                }
                if (AbstractGeneratorMojo.this.schemaLookupDirectories != null) {
                    for (int i = 0; i < AbstractGeneratorMojo.this.schemaLookupDirectories.length; ++i) {
                        File schemaLookupDirectory = AbstractGeneratorMojo.this.schemaLookupDirectories[i];
                        file = new File(schemaLookupDirectory, fileName);
                        if (!file.exists()) continue;
                        AbstractGeneratorMojo.this.getLog().debug((CharSequence)("Resolving " + schemaLocation + " to " + file.getAbsolutePath()));
                        return file.getAbsolutePath();
                    }
                }
                AbstractGeneratorMojo.this.getLog().warn((CharSequence)("Could not resolve location for: " + fileName));
                return null;
            }
        };
        XSDSchema xsdSchema = null;
        try {
            this.getLog().info((CharSequence)("Parsing schema: " + this.schemaLocation));
            xsdSchema = Schemas.parse((String)this.schemaLocation.getAbsolutePath(), (XSDSchemaLocator[])new XSDSchemaLocator[]{locator}, (XSDSchemaLocationResolver[])new XSDSchemaLocationResolver[]{locationResolver});
            if (xsdSchema == null) {
                throw new NullPointerException();
            }
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Failed to parse schema");
            this.getLog().error((Throwable)e);
            return null;
        }
        if (this.targetPrefix != null) {
            xsdSchema.getQNamePrefixToNamespaceMap().put(this.targetPrefix, xsdSchema.getTargetNamespace());
        }
        if (Schemas.getTargetPrefix((XSDSchema)xsdSchema) == null) {
            String msg = "Unable to determine a prefix for the target namespace of the schema Either  include a mapping in the schema or manually specify one with the 'targetPrefix' parameter.";
            throw new RuntimeException(msg);
        }
        return xsdSchema;
    }
}

