/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.maven.xmlcodegen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDSchema;
import org.geotools.maven.xmlcodegen.AbstractGenerator;
import org.geotools.xml.Schemas;

public class SchemaLocationResolverGenerator
extends AbstractGenerator {
    public void generate(XSDSchema schema) {
        ArrayList<File> includes = new ArrayList<File>();
        ArrayList<String> namespaces = new ArrayList<String>();
        File file = null;
        try {
            file = this.findSchemaFile(schema.getSchemaLocation());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
        if (file != null) {
            includes.add(file);
            namespaces.add(schema.getTargetNamespace());
        } else {
            logger.log(Level.SEVERE, "Could not find: " + schema.getSchemaLocation() + " to copy.");
        }
        List included = Schemas.getIncludes((XSDSchema)schema);
        for (XSDInclude xSDInclude : included) {
            file = null;
            try {
                file = this.findSchemaFile(xSDInclude.getSchemaLocation());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "", e);
            }
            if (file != null) {
                includes.add(file);
                if (xSDInclude.getSchema() != null) {
                    namespaces.add(xSDInclude.getSchema().getTargetNamespace());
                    continue;
                }
                namespaces.add(schema.getTargetNamespace());
                continue;
            }
            logger.log(Level.SEVERE, "Could not find: " + xSDInclude.getSchemaLocation() + " to copy.");
        }
        try {
            for (File file2 : includes) {
                this.copy(file2, this.resourceLocation);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error generating resolver", e);
        }
    }
}

