/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.opengis.gml.AbstractGMLType;
import net.opengis.gml.AbstractGeometricPrimitiveType;
import net.opengis.gml.AbstractGeometryBaseType;
import net.opengis.gml.AbstractGeometryType;
import net.opengis.gml.AbstractMetaDataType;
import net.opengis.gml.AbstractRingPropertyType;
import net.opengis.gml.AbstractRingType;
import net.opengis.gml.AbstractSurfaceType;
import net.opengis.gml.BoundingShapeType;
import net.opengis.gml.CodeListType;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.DocumentRoot;
import net.opengis.gml.EnvelopeType;
import net.opengis.gml.EnvelopeWithTimePeriodType;
import net.opengis.gml.GmlPackage;
import net.opengis.gml.GridEnvelopeType;
import net.opengis.gml.GridLimitsType;
import net.opengis.gml.GridType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.MetaDataPropertyType;
import net.opengis.gml.PointType;
import net.opengis.gml.PolygonType;
import net.opengis.gml.RectifiedGridType;
import net.opengis.gml.ReferenceType;
import net.opengis.gml.StringOrRefType;
import net.opengis.gml.TimeIndeterminateValueType;
import net.opengis.gml.TimePositionType;
import net.opengis.gml.VectorType;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.opengis.coverage.grid.GridEnvelope;

public class GmlValidator
extends EObjectValidator {
    public static final GmlValidator INSTANCE = new GmlValidator();
    public static final String DIAGNOSTIC_SOURCE = "net.opengis.gml";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;

    protected EPackage getEPackage() {
        return GmlPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateAbstractGeometricPrimitiveType((AbstractGeometricPrimitiveType)value, diagnostics, context);
            }
            case 1: {
                return this.validateAbstractGeometryBaseType((AbstractGeometryBaseType)value, diagnostics, context);
            }
            case 2: {
                return this.validateAbstractGeometryType((AbstractGeometryType)value, diagnostics, context);
            }
            case 3: {
                return this.validateAbstractGMLType((AbstractGMLType)value, diagnostics, context);
            }
            case 4: {
                return this.validateAbstractMetaDataType((AbstractMetaDataType)value, diagnostics, context);
            }
            case 5: {
                return this.validateAbstractRingPropertyType((AbstractRingPropertyType)value, diagnostics, context);
            }
            case 6: {
                return this.validateAbstractRingType((AbstractRingType)value, diagnostics, context);
            }
            case 7: {
                return this.validateAbstractSurfaceType((AbstractSurfaceType)value, diagnostics, context);
            }
            case 8: {
                return this.validateBoundingShapeType((BoundingShapeType)value, diagnostics, context);
            }
            case 9: {
                return this.validateCodeListType((CodeListType)value, diagnostics, context);
            }
            case 10: {
                return this.validateCodeType((CodeType)value, diagnostics, context);
            }
            case 11: {
                return this.validateDirectPositionType((DirectPositionType)value, diagnostics, context);
            }
            case 12: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 13: {
                return this.validateEnvelopeType((EnvelopeType)value, diagnostics, context);
            }
            case 14: {
                return this.validateEnvelopeWithTimePeriodType((EnvelopeWithTimePeriodType)value, diagnostics, context);
            }
            case 15: {
                return this.validateGridEnvelopeType((GridEnvelopeType)value, diagnostics, context);
            }
            case 16: {
                return this.validateGridLimitsType((GridLimitsType)value, diagnostics, context);
            }
            case 17: {
                return this.validateGridType((GridType)value, diagnostics, context);
            }
            case 18: {
                return this.validateLinearRingType((LinearRingType)value, diagnostics, context);
            }
            case 19: {
                return this.validateMetaDataPropertyType((MetaDataPropertyType)value, diagnostics, context);
            }
            case 20: {
                return this.validatePointType((PointType)value, diagnostics, context);
            }
            case 21: {
                return this.validatePolygonType((PolygonType)value, diagnostics, context);
            }
            case 22: {
                return this.validateRectifiedGridType((RectifiedGridType)value, diagnostics, context);
            }
            case 23: {
                return this.validateReferenceType((ReferenceType)value, diagnostics, context);
            }
            case 24: {
                return this.validateStringOrRefType((StringOrRefType)value, diagnostics, context);
            }
            case 25: {
                return this.validateTimePositionType((TimePositionType)value, diagnostics, context);
            }
            case 26: {
                return this.validateVectorType((VectorType)value, diagnostics, context);
            }
            case 27: {
                return this.validateTimeIndeterminateValueType((TimeIndeterminateValueType)((Object)value), diagnostics, context);
            }
            case 28: {
                return this.validateDoubleList((List)value, diagnostics, context);
            }
            case 29: {
                return this.validateIntegerList((List)value, diagnostics, context);
            }
            case 30: {
                return this.validateNameList((List)value, diagnostics, context);
            }
            case 31: {
                return this.validateTemporalPositionType(value, diagnostics, context);
            }
            case 32: {
                return this.validateTimeDurationType(value, diagnostics, context);
            }
            case 33: {
                return this.validateTimeIndeterminateValueTypeObject((TimeIndeterminateValueType)((Object)value), diagnostics, context);
            }
            case 34: {
                return this.validateVectorTypeBase((List)value, diagnostics, context);
            }
            case 35: {
                return this.validateGridEnvelope((GridEnvelope)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateAbstractGeometricPrimitiveType(AbstractGeometricPrimitiveType abstractGeometricPrimitiveType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractGeometricPrimitiveType, diagnostics, context);
    }

    public boolean validateAbstractGeometryBaseType(AbstractGeometryBaseType abstractGeometryBaseType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractGeometryBaseType, diagnostics, context);
    }

    public boolean validateAbstractGeometryType(AbstractGeometryType abstractGeometryType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractGeometryType, diagnostics, context);
    }

    public boolean validateAbstractGMLType(AbstractGMLType abstractGMLType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractGMLType, diagnostics, context);
    }

    public boolean validateAbstractMetaDataType(AbstractMetaDataType abstractMetaDataType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractMetaDataType, diagnostics, context);
    }

    public boolean validateAbstractRingPropertyType(AbstractRingPropertyType abstractRingPropertyType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractRingPropertyType, diagnostics, context);
    }

    public boolean validateAbstractRingType(AbstractRingType abstractRingType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractRingType, diagnostics, context);
    }

    public boolean validateAbstractSurfaceType(AbstractSurfaceType abstractSurfaceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(abstractSurfaceType, diagnostics, context);
    }

    public boolean validateBoundingShapeType(BoundingShapeType boundingShapeType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(boundingShapeType, diagnostics, context);
    }

    public boolean validateCodeListType(CodeListType codeListType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(codeListType, diagnostics, context);
    }

    public boolean validateCodeType(CodeType codeType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(codeType, diagnostics, context);
    }

    public boolean validateDirectPositionType(DirectPositionType directPositionType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(directPositionType, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateEnvelopeType(EnvelopeType envelopeType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(envelopeType, diagnostics, context);
    }

    public boolean validateEnvelopeWithTimePeriodType(EnvelopeWithTimePeriodType envelopeWithTimePeriodType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(envelopeWithTimePeriodType, diagnostics, context);
    }

    public boolean validateGridEnvelopeType(GridEnvelopeType gridEnvelopeType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(gridEnvelopeType, diagnostics, context);
    }

    public boolean validateGridLimitsType(GridLimitsType gridLimitsType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(gridLimitsType, diagnostics, context);
    }

    public boolean validateGridType(GridType gridType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(gridType, diagnostics, context);
    }

    public boolean validateLinearRingType(LinearRingType linearRingType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(linearRingType, diagnostics, context);
    }

    public boolean validateMetaDataPropertyType(MetaDataPropertyType metaDataPropertyType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(metaDataPropertyType, diagnostics, context);
    }

    public boolean validatePointType(PointType pointType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(pointType, diagnostics, context);
    }

    public boolean validatePolygonType(PolygonType polygonType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(polygonType, diagnostics, context);
    }

    public boolean validateRectifiedGridType(RectifiedGridType rectifiedGridType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(rectifiedGridType, diagnostics, context);
    }

    public boolean validateReferenceType(ReferenceType referenceType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(referenceType, diagnostics, context);
    }

    public boolean validateStringOrRefType(StringOrRefType stringOrRefType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(stringOrRefType, diagnostics, context);
    }

    public boolean validateTimePositionType(TimePositionType timePositionType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(timePositionType, diagnostics, context);
    }

    public boolean validateVectorType(VectorType vectorType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(vectorType, diagnostics, context);
    }

    public boolean validateTimeIndeterminateValueType(TimeIndeterminateValueType timeIndeterminateValueType, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateDoubleList(List doubleList, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateDoubleList_ItemType(doubleList, diagnostics, context);
        return result;
    }

    public boolean validateDoubleList_ItemType(List doubleList, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator i = doubleList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.DOUBLE.isInstance(item)) {
                result &= this.xmlTypeValidator.validateDouble(((Double)item).doubleValue(), diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.DOUBLE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateIntegerList(List integerList, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateIntegerList_ItemType(integerList, diagnostics, context);
        return result;
    }

    public boolean validateIntegerList_ItemType(List integerList, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator i = integerList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.INTEGER.isInstance(item)) {
                result &= this.xmlTypeValidator.validateInteger((BigInteger)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.INTEGER, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateNameList(List nameList, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateNameList_ItemType(nameList, diagnostics, context);
        return result;
    }

    public boolean validateNameList_ItemType(List nameList, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator i = nameList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.NAME.isInstance(item)) {
                result &= this.xmlTypeValidator.validateName((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.NAME, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateTemporalPositionType(Object temporalPositionType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateTemporalPositionType_MemberTypes(temporalPositionType, diagnostics, context);
        return result;
    }

    public boolean validateTemporalPositionType_MemberTypes(Object temporalPositionType, DiagnosticChain diagnostics, Map context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (XMLTypePackage.Literals.DATE_TIME.isInstance(temporalPositionType) && this.xmlTypeValidator.validateDateTime(temporalPositionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.DATE.isInstance(temporalPositionType) && this.xmlTypeValidator.validateDate(temporalPositionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.GYEAR_MONTH.isInstance(temporalPositionType) && this.xmlTypeValidator.validateGYearMonth(temporalPositionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.GYEAR.isInstance(temporalPositionType) && this.xmlTypeValidator.validateGYear(temporalPositionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.ANY_URI.isInstance(temporalPositionType) && this.xmlTypeValidator.validateAnyURI((String)temporalPositionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.DECIMAL.isInstance(temporalPositionType) && this.xmlTypeValidator.validateDecimal((BigDecimal)temporalPositionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            List children = tempDiagnostics.getChildren();
            int i = 0;
            while (i < children.size()) {
                diagnostics.add((Diagnostic)children.get(i));
                ++i;
            }
        } else {
            if (XMLTypePackage.Literals.DATE_TIME.isInstance(temporalPositionType) && this.xmlTypeValidator.validateDateTime(temporalPositionType, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.DATE.isInstance(temporalPositionType) && this.xmlTypeValidator.validateDate(temporalPositionType, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.GYEAR_MONTH.isInstance(temporalPositionType) && this.xmlTypeValidator.validateGYearMonth(temporalPositionType, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.GYEAR.isInstance(temporalPositionType) && this.xmlTypeValidator.validateGYear(temporalPositionType, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.ANY_URI.isInstance(temporalPositionType) && this.xmlTypeValidator.validateAnyURI((String)temporalPositionType, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.DECIMAL.isInstance(temporalPositionType) && this.xmlTypeValidator.validateDecimal((BigDecimal)temporalPositionType, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateTimeDurationType(Object timeDurationType, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateTimeDurationType_MemberTypes(timeDurationType, diagnostics, context);
        return result;
    }

    public boolean validateTimeDurationType_MemberTypes(Object timeDurationType, DiagnosticChain diagnostics, Map context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (XMLTypePackage.Literals.DURATION.isInstance(timeDurationType) && this.xmlTypeValidator.validateDuration(timeDurationType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.DECIMAL.isInstance(timeDurationType) && this.xmlTypeValidator.validateDecimal((BigDecimal)timeDurationType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            List children = tempDiagnostics.getChildren();
            int i = 0;
            while (i < children.size()) {
                diagnostics.add((Diagnostic)children.get(i));
                ++i;
            }
        } else {
            if (XMLTypePackage.Literals.DURATION.isInstance(timeDurationType) && this.xmlTypeValidator.validateDuration(timeDurationType, null, context)) {
                return true;
            }
            if (XMLTypePackage.Literals.DECIMAL.isInstance(timeDurationType) && this.xmlTypeValidator.validateDecimal((BigDecimal)timeDurationType, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateTimeIndeterminateValueTypeObject(TimeIndeterminateValueType timeIndeterminateValueTypeObject, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public boolean validateVectorTypeBase(List vectorTypeBase, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateDoubleList_ItemType(vectorTypeBase, diagnostics, context);
        return result;
    }

    public boolean validateGridEnvelope(GridEnvelope gridEnvelope, DiagnosticChain diagnostics, Map context) {
        return true;
    }
}

