/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package net.opengis.wcs11.validation;

import net.opengis.ows11.ReferenceGroupType;

import net.opengis.wcs11.AvailableKeysType;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.CapabilitiesType;
import net.opengis.wcs11.ContentsType;
import net.opengis.wcs11.CoverageDescriptionsType;
import net.opengis.wcs11.CoverageSummaryType;
import net.opengis.wcs11.CoveragesType;
import net.opengis.wcs11.DescribeCoverageType;
import net.opengis.wcs11.GetCapabilitiesType;
import net.opengis.wcs11.GetCoverageType;
import net.opengis.wcs11.GridCrsType;
import net.opengis.wcs11.InterpolationMethodsType;
import net.opengis.wcs11.TimeSequenceType;

import org.eclipse.emf.common.util.EMap;

import org.eclipse.emf.ecore.util.FeatureMap;

/**
 * A sample validator interface for {@link net.opengis.wcs11.DocumentRoot}.
 * This doesn't really do anything, and it's not a real EMF artifact.
 * It was generated by the org.eclipse.emf.examples.generator.validator plug-in to illustrate how EMF's code generator can be extended.
 * This can be disabled with -vmargs -Dorg.eclipse.emf.examples.generator.validator=false.
 */
public interface DocumentRootValidator {
    boolean validate();

    boolean validateMixed(FeatureMap value);
    boolean validateXMLNSPrefixMap(EMap value);
    boolean validateXSISchemaLocation(EMap value);
    boolean validateAvailableKeys(AvailableKeysType value);
    boolean validateAxisSubset(AxisSubsetType value);
    boolean validateCapabilities(CapabilitiesType value);
    boolean validateContents(ContentsType value);
    boolean validateCoverage(ReferenceGroupType value);
    boolean validateCoverageDescriptions(CoverageDescriptionsType value);
    boolean validateCoverages(CoveragesType value);
    boolean validateCoverageSummary(CoverageSummaryType value);
    boolean validateDescribeCoverage(DescribeCoverageType value);
    boolean validateGetCapabilities(GetCapabilitiesType value);
    boolean validateGetCoverage(GetCoverageType value);
    boolean validateGridBaseCRS(String value);
    boolean validateGridCRS(GridCrsType value);
    boolean validateGridCS(String value);
    boolean validateGridOffsets(Object value);
    boolean validateGridOrigin(Object value);
    boolean validateGridType(String value);
    boolean validateIdentifier(String value);
    boolean validateInterpolationMethods(InterpolationMethodsType value);
    boolean validateTemporalDomain(TimeSequenceType value);
    boolean validateTemporalSubset(TimeSequenceType value);
}
