/*
 * Decompiled with CFR 0.152.
 */
package net.opengis.gml.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.opengis.gml.AbstractRingPropertyType;
import net.opengis.gml.AbstractSurfaceType;
import net.opengis.gml.BoundingShapeType;
import net.opengis.gml.CodeListType;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.DocumentRoot;
import net.opengis.gml.EnvelopeType;
import net.opengis.gml.EnvelopeWithTimePeriodType;
import net.opengis.gml.GmlFactory;
import net.opengis.gml.GmlPackage;
import net.opengis.gml.GridEnvelopeType;
import net.opengis.gml.GridLimitsType;
import net.opengis.gml.GridType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.MetaDataPropertyType;
import net.opengis.gml.PointType;
import net.opengis.gml.PolygonType;
import net.opengis.gml.RectifiedGridType;
import net.opengis.gml.ReferenceType;
import net.opengis.gml.StringOrRefType;
import net.opengis.gml.TimeIndeterminateValueType;
import net.opengis.gml.TimePositionType;
import net.opengis.gml.VectorType;
import net.opengis.gml.impl.AbstractRingPropertyTypeImpl;
import net.opengis.gml.impl.AbstractSurfaceTypeImpl;
import net.opengis.gml.impl.BoundingShapeTypeImpl;
import net.opengis.gml.impl.CodeListTypeImpl;
import net.opengis.gml.impl.CodeTypeImpl;
import net.opengis.gml.impl.DirectPositionTypeImpl;
import net.opengis.gml.impl.DocumentRootImpl;
import net.opengis.gml.impl.EnvelopeTypeImpl;
import net.opengis.gml.impl.EnvelopeWithTimePeriodTypeImpl;
import net.opengis.gml.impl.GridEnvelopeTypeImpl;
import net.opengis.gml.impl.GridLimitsTypeImpl;
import net.opengis.gml.impl.GridTypeImpl;
import net.opengis.gml.impl.LinearRingTypeImpl;
import net.opengis.gml.impl.MetaDataPropertyTypeImpl;
import net.opengis.gml.impl.PointTypeImpl;
import net.opengis.gml.impl.PolygonTypeImpl;
import net.opengis.gml.impl.RectifiedGridTypeImpl;
import net.opengis.gml.impl.ReferenceTypeImpl;
import net.opengis.gml.impl.StringOrRefTypeImpl;
import net.opengis.gml.impl.TimePositionTypeImpl;
import net.opengis.gml.impl.VectorTypeImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.opengis.coverage.grid.GridEnvelope;

public class GmlFactoryImpl
extends EFactoryImpl
implements GmlFactory {
    public static GmlFactory init() {
        try {
            GmlFactory theGmlFactory = (GmlFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.opengis.net/gml");
            if (theGmlFactory != null) {
                return theGmlFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new GmlFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 5: {
                return this.createAbstractRingPropertyType();
            }
            case 7: {
                return this.createAbstractSurfaceType();
            }
            case 8: {
                return this.createBoundingShapeType();
            }
            case 9: {
                return this.createCodeListType();
            }
            case 10: {
                return this.createCodeType();
            }
            case 11: {
                return this.createDirectPositionType();
            }
            case 12: {
                return this.createDocumentRoot();
            }
            case 13: {
                return this.createEnvelopeType();
            }
            case 14: {
                return this.createEnvelopeWithTimePeriodType();
            }
            case 15: {
                return this.createGridEnvelopeType();
            }
            case 16: {
                return this.createGridLimitsType();
            }
            case 17: {
                return this.createGridType();
            }
            case 18: {
                return this.createLinearRingType();
            }
            case 19: {
                return this.createMetaDataPropertyType();
            }
            case 20: {
                return this.createPointType();
            }
            case 21: {
                return this.createPolygonType();
            }
            case 22: {
                return this.createRectifiedGridType();
            }
            case 23: {
                return this.createReferenceType();
            }
            case 24: {
                return this.createStringOrRefType();
            }
            case 25: {
                return this.createTimePositionType();
            }
            case 26: {
                return this.createVectorType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 27: {
                return this.createTimeIndeterminateValueTypeFromString(eDataType, initialValue);
            }
            case 28: {
                return this.createDoubleListFromString(eDataType, initialValue);
            }
            case 29: {
                return this.createIntegerListFromString(eDataType, initialValue);
            }
            case 30: {
                return this.createNameListFromString(eDataType, initialValue);
            }
            case 31: {
                return this.createTemporalPositionTypeFromString(eDataType, initialValue);
            }
            case 32: {
                return this.createTimeDurationTypeFromString(eDataType, initialValue);
            }
            case 33: {
                return this.createTimeIndeterminateValueTypeObjectFromString(eDataType, initialValue);
            }
            case 34: {
                return this.createVectorTypeBaseFromString(eDataType, initialValue);
            }
            case 35: {
                return this.createGridEnvelopeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 27: {
                return this.convertTimeIndeterminateValueTypeToString(eDataType, instanceValue);
            }
            case 28: {
                return this.convertDoubleListToString(eDataType, instanceValue);
            }
            case 29: {
                return this.convertIntegerListToString(eDataType, instanceValue);
            }
            case 30: {
                return this.convertNameListToString(eDataType, instanceValue);
            }
            case 31: {
                return this.convertTemporalPositionTypeToString(eDataType, instanceValue);
            }
            case 32: {
                return this.convertTimeDurationTypeToString(eDataType, instanceValue);
            }
            case 33: {
                return this.convertTimeIndeterminateValueTypeObjectToString(eDataType, instanceValue);
            }
            case 34: {
                return this.convertVectorTypeBaseToString(eDataType, instanceValue);
            }
            case 35: {
                return this.convertGridEnvelopeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public AbstractRingPropertyType createAbstractRingPropertyType() {
        AbstractRingPropertyTypeImpl abstractRingPropertyType = new AbstractRingPropertyTypeImpl();
        return abstractRingPropertyType;
    }

    public AbstractSurfaceType createAbstractSurfaceType() {
        AbstractSurfaceTypeImpl abstractSurfaceType = new AbstractSurfaceTypeImpl();
        return abstractSurfaceType;
    }

    public BoundingShapeType createBoundingShapeType() {
        BoundingShapeTypeImpl boundingShapeType = new BoundingShapeTypeImpl();
        return boundingShapeType;
    }

    public CodeListType createCodeListType() {
        CodeListTypeImpl codeListType = new CodeListTypeImpl();
        return codeListType;
    }

    public CodeType createCodeType() {
        CodeTypeImpl codeType = new CodeTypeImpl();
        return codeType;
    }

    public DirectPositionType createDirectPositionType() {
        DirectPositionTypeImpl directPositionType = new DirectPositionTypeImpl();
        return directPositionType;
    }

    public DocumentRoot createDocumentRoot() {
        DocumentRootImpl documentRoot = new DocumentRootImpl();
        return documentRoot;
    }

    public EnvelopeType createEnvelopeType() {
        EnvelopeTypeImpl envelopeType = new EnvelopeTypeImpl();
        return envelopeType;
    }

    public EnvelopeWithTimePeriodType createEnvelopeWithTimePeriodType() {
        EnvelopeWithTimePeriodTypeImpl envelopeWithTimePeriodType = new EnvelopeWithTimePeriodTypeImpl();
        return envelopeWithTimePeriodType;
    }

    public GridEnvelopeType createGridEnvelopeType() {
        GridEnvelopeTypeImpl gridEnvelopeType = new GridEnvelopeTypeImpl();
        return gridEnvelopeType;
    }

    public GridLimitsType createGridLimitsType() {
        GridLimitsTypeImpl gridLimitsType = new GridLimitsTypeImpl();
        return gridLimitsType;
    }

    public GridType createGridType() {
        GridTypeImpl gridType = new GridTypeImpl();
        return gridType;
    }

    public LinearRingType createLinearRingType() {
        LinearRingTypeImpl linearRingType = new LinearRingTypeImpl();
        return linearRingType;
    }

    public MetaDataPropertyType createMetaDataPropertyType() {
        MetaDataPropertyTypeImpl metaDataPropertyType = new MetaDataPropertyTypeImpl();
        return metaDataPropertyType;
    }

    public PointType createPointType() {
        PointTypeImpl pointType = new PointTypeImpl();
        return pointType;
    }

    public PolygonType createPolygonType() {
        PolygonTypeImpl polygonType = new PolygonTypeImpl();
        return polygonType;
    }

    public RectifiedGridType createRectifiedGridType() {
        RectifiedGridTypeImpl rectifiedGridType = new RectifiedGridTypeImpl();
        return rectifiedGridType;
    }

    public ReferenceType createReferenceType() {
        ReferenceTypeImpl referenceType = new ReferenceTypeImpl();
        return referenceType;
    }

    public StringOrRefType createStringOrRefType() {
        StringOrRefTypeImpl stringOrRefType = new StringOrRefTypeImpl();
        return stringOrRefType;
    }

    public TimePositionType createTimePositionType() {
        TimePositionTypeImpl timePositionType = new TimePositionTypeImpl();
        return timePositionType;
    }

    public VectorType createVectorType() {
        VectorTypeImpl vectorType = new VectorTypeImpl();
        return vectorType;
    }

    public TimeIndeterminateValueType createTimeIndeterminateValueTypeFromString(EDataType eDataType, String initialValue) {
        TimeIndeterminateValueType result = TimeIndeterminateValueType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertTimeIndeterminateValueTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public List createDoubleListFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<Double> result = new ArrayList<Double>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add((Double)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DOUBLE, item));
        }
        return result;
    }

    public String convertDoubleListToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DOUBLE, i.next()));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    public List createIntegerListFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<BigInteger> result = new ArrayList<BigInteger>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add((BigInteger)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.INTEGER, item));
        }
        return result;
    }

    public String convertIntegerListToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.INTEGER, i.next()));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    public List createNameListFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(initialValue);
        while (stringTokenizer.hasMoreTokens()) {
            String item = stringTokenizer.nextToken();
            result.add((String)XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.NAME, item));
        }
        return result;
    }

    public String convertNameListToString(EDataType eDataType, Object instanceValue) {
        if (instanceValue == null) {
            return null;
        }
        List list = (List)instanceValue;
        if (list.isEmpty()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            result.append(XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.NAME, i.next()));
            result.append(' ');
        }
        return result.substring(0, result.length() - 1);
    }

    public Object createTemporalPositionTypeFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        Object result = null;
        RuntimeException exception = null;
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DATE_TIME, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DATE, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.GYEAR_MONTH, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.GYEAR, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.ANY_URI, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DECIMAL, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (result != null || exception == null) {
            return result;
        }
        throw exception;
    }

    public String convertTemporalPositionTypeToString(EDataType eDataType, Object instanceValue) {
        String value;
        if (instanceValue == null) {
            return null;
        }
        if (XMLTypePackage.Literals.DATE_TIME.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DATE_TIME, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (XMLTypePackage.Literals.DATE.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DATE, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (XMLTypePackage.Literals.GYEAR_MONTH.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.GYEAR_MONTH, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (XMLTypePackage.Literals.GYEAR.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.GYEAR, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (XMLTypePackage.Literals.ANY_URI.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.ANY_URI, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (XMLTypePackage.Literals.DECIMAL.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DECIMAL, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName());
    }

    public Object createTimeDurationTypeFromString(EDataType eDataType, String initialValue) {
        if (initialValue == null) {
            return null;
        }
        Object result = null;
        RuntimeException exception = null;
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DURATION, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        try {
            result = XMLTypeFactory.eINSTANCE.createFromString(XMLTypePackage.Literals.DECIMAL, initialValue);
            if (result != null && Diagnostician.INSTANCE.validate(eDataType, result, null, null)) {
                return result;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        if (result != null || exception == null) {
            return result;
        }
        throw exception;
    }

    public String convertTimeDurationTypeToString(EDataType eDataType, Object instanceValue) {
        String value;
        if (instanceValue == null) {
            return null;
        }
        if (XMLTypePackage.Literals.DURATION.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DURATION, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (XMLTypePackage.Literals.DECIMAL.isInstance(instanceValue)) {
            try {
                value = XMLTypeFactory.eINSTANCE.convertToString(XMLTypePackage.Literals.DECIMAL, instanceValue);
                if (value != null) {
                    return value;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Invalid value: '" + instanceValue + "' for datatype :" + eDataType.getName());
    }

    public TimeIndeterminateValueType createTimeIndeterminateValueTypeObjectFromString(EDataType eDataType, String initialValue) {
        return this.createTimeIndeterminateValueTypeFromString((EDataType)GmlPackage.Literals.TIME_INDETERMINATE_VALUE_TYPE, initialValue);
    }

    public String convertTimeIndeterminateValueTypeObjectToString(EDataType eDataType, Object instanceValue) {
        return this.convertTimeIndeterminateValueTypeToString((EDataType)GmlPackage.Literals.TIME_INDETERMINATE_VALUE_TYPE, instanceValue);
    }

    public List createVectorTypeBaseFromString(EDataType eDataType, String initialValue) {
        return this.createDoubleListFromString(GmlPackage.Literals.DOUBLE_LIST, initialValue);
    }

    public String convertVectorTypeBaseToString(EDataType eDataType, Object instanceValue) {
        return this.convertDoubleListToString(GmlPackage.Literals.DOUBLE_LIST, instanceValue);
    }

    public GridEnvelope createGridEnvelopeFromString(EDataType eDataType, String initialValue) {
        return (GridEnvelope)super.createFromString(eDataType, initialValue);
    }

    public String convertGridEnvelopeToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public GmlPackage getGmlPackage() {
        return (GmlPackage)this.getEPackage();
    }

    public static GmlPackage getPackage() {
        return GmlPackage.eINSTANCE;
    }
}

