/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.start;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.StringTokenizer;
import java.util.Vector;

public class Classpath {
    Vector _elements = new Vector();

    public Classpath() {
    }

    public Classpath(String initial) {
        this.addClasspath(initial);
    }

    public boolean addComponent(String component) {
        if (component != null && component.length() > 0) {
            try {
                File key;
                File f = new File(component);
                if (f.exists() && !this._elements.contains(key = f.getCanonicalFile())) {
                    this._elements.add(key);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean addComponent(File component) {
        if (component != null) {
            try {
                File key;
                if (component.exists() && !this._elements.contains(key = component.getCanonicalFile())) {
                    this._elements.add(key);
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean addClasspath(String s) {
        boolean added = false;
        if (s != null) {
            StringTokenizer t = new StringTokenizer(s, File.pathSeparator);
            while (t.hasMoreTokens()) {
                added |= this.addComponent(t.nextToken());
            }
        }
        return added;
    }

    public String toString() {
        StringBuffer cp = new StringBuffer(1024);
        int cnt = this._elements.size();
        if (cnt >= 1) {
            cp.append(((File)this._elements.elementAt(0)).getPath());
        }
        for (int i = 1; i < cnt; ++i) {
            cp.append(File.pathSeparatorChar);
            cp.append(((File)this._elements.elementAt(i)).getPath());
        }
        return cp.toString();
    }

    public ClassLoader getClassLoader() {
        int cnt = this._elements.size();
        URL[] urls = new URL[cnt];
        for (int i = 0; i < cnt; ++i) {
            try {
                String u = ((File)this._elements.elementAt(i)).toURL().toString();
                u = Classpath.encodeFileURL(u);
                urls[i] = new URL(u);
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        ClassLoader parent = Thread.currentThread().getContextClassLoader();
        if (parent == null) {
            parent = Classpath.class.getClassLoader();
        }
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        return new Loader(urls, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String encodeFileURL(String path) {
        byte[] bytes;
        try {
            bytes = path.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            bytes = path.getBytes();
        }
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        buf.append("file:");
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            block10: for (int i = 5; i < bytes.length; ++i) {
                byte b = bytes[i];
                switch (b) {
                    case 37: {
                        buf.append("%25");
                        continue block10;
                    }
                    case 32: {
                        buf.append("%20");
                        continue block10;
                    }
                    case 45: 
                    case 46: 
                    case 47: 
                    case 95: {
                        buf.append((char)b);
                        continue block10;
                    }
                    default: {
                        if (Character.isJavaIdentifierPart((char)b) && (b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57)) {
                            buf.append((char)b);
                            continue block10;
                        }
                        buf.append('%');
                        buf.append(Integer.toHexString((0xF0 & b) >> 4));
                        buf.append(Integer.toHexString(0xF & b));
                        continue block10;
                    }
                }
            }
        }
        return buf.toString();
    }

    private class Loader
    extends URLClassLoader {
        String name;

        Loader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
            this.name = "StartLoader" + Arrays.asList(urls);
        }

        public String toString() {
            return this.name;
        }
    }
}

