/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.animator;

import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.visual.animator.AnimatorEvent;
import org.netbeans.api.visual.animator.AnimatorListener;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Scene;

public abstract class Animator {
    private CopyOnWriteArrayList<AnimatorListener> listeners = new CopyOnWriteArrayList();
    private SceneAnimator sceneAnimator;
    private boolean reset;

    protected Animator(SceneAnimator sceneAnimator) {
        assert (sceneAnimator != null);
        this.sceneAnimator = sceneAnimator;
    }

    protected final Scene getScene() {
        return this.sceneAnimator.getScene();
    }

    protected final void start() {
        if (!this.listeners.isEmpty()) {
            AnimatorEvent event = new AnimatorEvent(this);
            for (AnimatorListener listener : this.listeners) {
                listener.animatorStarted(event);
            }
        }
        this.sceneAnimator.start(this);
    }

    public final boolean isRunning() {
        return this.sceneAnimator.isRunning(this);
    }

    final void reset() {
        if (!this.listeners.isEmpty()) {
            AnimatorEvent event = new AnimatorEvent(this);
            for (AnimatorListener listener : this.listeners) {
                listener.animatorReset(event);
            }
        }
        this.reset = true;
    }

    final void performTick(double progress) {
        AnimatorEvent event;
        if (this.reset) {
            this.reset = false;
            return;
        }
        if (!this.listeners.isEmpty()) {
            event = new AnimatorEvent(this, progress);
            for (AnimatorListener listener : this.listeners) {
                listener.animatorPreTick(event);
            }
        }
        this.tick(progress);
        if (!this.listeners.isEmpty()) {
            event = new AnimatorEvent(this, progress);
            for (AnimatorListener listener : this.listeners) {
                listener.animatorPostTick(event);
            }
        }
        if (progress >= 1.0 && !this.listeners.isEmpty()) {
            event = new AnimatorEvent(this);
            for (AnimatorListener listener : this.listeners) {
                listener.animatorFinished(event);
            }
        }
    }

    protected abstract void tick(double var1);

    public void addAnimatorListener(AnimatorListener listener) {
        this.listeners.add(listener);
    }

    public void removeAnimatorListener(AnimatorListener listener) {
        this.listeners.remove(listener);
    }
}

