/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.animator;

import java.awt.Color;
import java.awt.Paint;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.animator.Animator;
import org.netbeans.api.visual.animator.SceneAnimator;
import org.netbeans.api.visual.widget.Widget;

public final class ColorAnimator
extends Animator {
    private HashMap<Widget, Color> sourceBackgroundColors = new HashMap();
    private HashMap<Widget, Color> targetBackgroundColors = new HashMap();
    private HashMap<Widget, Color> sourceForegroundColors = new HashMap();
    private HashMap<Widget, Color> targetForegroundColors = new HashMap();

    public ColorAnimator(SceneAnimator sceneAnimator) {
        super(sceneAnimator);
    }

    public void setBackgroundColor(Widget widget, Color backgroundColor) {
        assert (widget != null);
        assert (backgroundColor != null);
        this.sourceBackgroundColors.clear();
        this.targetBackgroundColors.put(widget, backgroundColor);
        this.start();
    }

    public void setForegroundColor(Widget widget, Color foregroundColor) {
        assert (widget != null);
        assert (foregroundColor != null);
        this.sourceForegroundColors.clear();
        this.targetForegroundColors.put(widget, foregroundColor);
        this.start();
    }

    @Override
    protected void tick(double progress) {
        Color color;
        Color targetColor;
        Color sourceColor;
        Widget widget;
        for (Map.Entry<Widget, Color> entry : this.targetBackgroundColors.entrySet()) {
            widget = entry.getKey();
            sourceColor = this.sourceBackgroundColors.get(widget);
            if (sourceColor == null) {
                Paint background = widget.getBackground();
                sourceColor = background instanceof Color ? (Color)background : Color.WHITE;
                this.sourceBackgroundColors.put(widget, sourceColor);
            }
            targetColor = entry.getValue();
            color = progress >= 1.0 ? targetColor : new Color((int)((double)sourceColor.getRed() + progress * (double)(targetColor.getRed() - sourceColor.getRed())), (int)((double)sourceColor.getGreen() + progress * (double)(targetColor.getGreen() - sourceColor.getGreen())), (int)((double)sourceColor.getBlue() + progress * (double)(targetColor.getBlue() - sourceColor.getBlue())));
            widget.setBackground(color);
        }
        for (Map.Entry<Widget, Color> entry : this.targetForegroundColors.entrySet()) {
            widget = entry.getKey();
            sourceColor = this.sourceForegroundColors.get(widget);
            if (sourceColor == null) {
                sourceColor = widget.getForeground();
                this.sourceForegroundColors.put(widget, sourceColor);
            }
            targetColor = entry.getValue();
            color = progress >= 1.0 ? targetColor : new Color((int)((double)sourceColor.getRed() + progress * (double)(targetColor.getRed() - sourceColor.getRed())), (int)((double)sourceColor.getGreen() + progress * (double)(targetColor.getGreen() - sourceColor.getGreen())), (int)((double)sourceColor.getBlue() + progress * (double)(targetColor.getBlue() - sourceColor.getBlue())));
            widget.setForeground(color);
        }
        if (progress >= 1.0) {
            this.sourceBackgroundColors.clear();
            this.targetBackgroundColors.clear();
            this.sourceForegroundColors.clear();
            this.targetForegroundColors.clear();
        }
    }
}

