/*
 * Decompiled with CFR 0.152.
 */
package geodb;

import henplus.HenPlus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import org.h2.tools.Server;

public class Prompt {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            Prompt.printUsageAndExit();
        }
        ArrayList<String> params = new ArrayList<String>(Arrays.asList(args));
        boolean web = false;
        Iterator i = params.iterator();
        while (i.hasNext()) {
            String arg = (String)i.next();
            if (!"-w".equals(arg) && !"--web".equals(arg)) continue;
            i.remove();
            web = true;
        }
        if (web) {
            Prompt.runAsWeb();
        } else {
            if (params.isEmpty()) {
                Prompt.printUsageAndExit();
            }
            String database = (String)params.get(params.size() - 1);
            Prompt.runAsCommandLine(database);
        }
    }

    static void printUsageAndExit() {
        System.out.println("Usage: geodb [options] <database>");
        System.out.println();
        System.out.println("Options:");
        System.out.println("\t --web, -w\t\trun as web application");
        System.exit(-1);
    }

    static void runAsWeb() throws Exception {
        Server.main((String[])new String[0]);
    }

    static void runAsCommandLine(String database) throws Exception {
        File hpconfig;
        String home = System.getProperty("user.home");
        File hpdir = new File(home, ".henplus");
        if (!hpdir.exists()) {
            if (!hpdir.getParentFile().canWrite()) {
                System.out.println("ERROR: Can not write to home directory");
                System.exit(-1);
            }
            hpdir.mkdir();
        }
        if (!(hpconfig = new File(hpdir, "drivers")).exists()) {
            hpconfig.createNewFile();
        }
        if (!hpconfig.exists()) {
            System.out.println("ERROR: Could not create HenPlus configuration");
            System.exit(-1);
        }
        Properties hpprops = new Properties();
        FileInputStream fin = new FileInputStream(hpconfig);
        hpprops.load(fin);
        fin.close();
        if (!hpprops.containsKey("driver.h2.class")) {
            hpprops.put("driver.h2.class", "org.h2.Driver");
            FileOutputStream fout = new FileOutputStream(hpconfig);
            hpprops.store(fout, "JDBC drivers");
            fout.close();
        }
        HenPlus.main((String[])new String[]{"jdbc:h2:" + database});
    }
}

