/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.awt.Component;
import java.util.regex.Pattern;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.util.Strings;
import org.fest.util.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NamedComponentMatcherTemplate<T extends Component>
extends GenericTypeMatcher<T> {
    protected static final Object ANY = new Object(){

        public String toString() {
            return "<Any>";
        }
    };
    protected final Object name;

    protected NamedComponentMatcherTemplate(Class<T> supportedType) {
        super(supportedType);
        this.name = ANY;
    }

    protected NamedComponentMatcherTemplate(Class<T> supportedType, Object name) {
        super(supportedType);
        this.name = name;
    }

    protected final Object quotedName() {
        return this.quoted(this.name);
    }

    protected final Object quoted(Object propertyValue) {
        if (ANY.equals(propertyValue)) {
            return ANY;
        }
        if (propertyValue instanceof Pattern) {
            return org.fest.util.Strings.quote(((Pattern)propertyValue).pattern());
        }
        return org.fest.util.Strings.quote(propertyValue);
    }

    protected final boolean isNameMatching(String actual) {
        if (ANY.equals(this.name)) {
            return true;
        }
        return Objects.areEqual(this.name, actual);
    }

    protected final boolean arePropertyValuesMatching(Object expected, Object actual) {
        if (ANY.equals(expected)) {
            return true;
        }
        if (expected instanceof String && actual instanceof String) {
            return Strings.areEqualOrMatch((String)expected, (String)actual);
        }
        if (expected instanceof Pattern && actual instanceof CharSequence) {
            return Strings.match((Pattern)expected, (CharSequence)actual);
        }
        return Objects.areEqual(expected, actual);
    }
}

