/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.security;

import java.security.Permission;
import org.fest.swing.security.ExitCallHook;
import org.fest.swing.security.ExitException;
import org.fest.util.StackTraces;
import org.fest.util.Strings;
import org.fest.util.VisibleForTesting;

public class NoExitSecurityManager
extends SecurityManager {
    private static final ExitCallHook NULL_HOOK = new ExitCallHook(){

        public void exitCalled(int status) {
        }
    };
    private final ExitCallHook hook;
    private final StackTraces stackTraces;

    public NoExitSecurityManager() {
        this(NULL_HOOK);
    }

    public NoExitSecurityManager(ExitCallHook hook) {
        this(hook, StackTraces.instance());
    }

    @VisibleForTesting
    NoExitSecurityManager(ExitCallHook hook, StackTraces stackTraces) {
        if (hook == null) {
            throw new NullPointerException(Strings.concat("The given ", ExitCallHook.class.getSimpleName(), " should not be null"));
        }
        this.hook = hook;
        this.stackTraces = stackTraces;
    }

    public void checkPermission(Permission permission, Object context) {
    }

    public void checkPermission(Permission permission) {
    }

    public void checkExit(int status) {
        if (this.exitInvoked()) {
            this.hook.exitCalled(status);
            throw new ExitException(Strings.concat("Application tried to terminate current JVM with status ", status));
        }
    }

    private boolean exitInvoked() {
        for (StackTraceElement e : this.stackTraces.stackTraceInCurrentThread()) {
            if (!this.exitInvoked(e)) continue;
            return true;
        }
        return false;
    }

    private boolean exitInvoked(StackTraceElement e) {
        if (!Runtime.class.getName().equals(e.getClassName())) {
            return false;
        }
        String method = e.getMethodName();
        return "exit".equals(method) || "halt".equals(method);
    }
}

