/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.assertions.PrimitiveAssert;
import org.fest.util.Strings;

public class CharAssert
extends PrimitiveAssert {
    private final char actual;

    protected CharAssert(char actual) {
        this.actual = actual;
    }

    public CharAssert as(String description) {
        this.description(description);
        return this;
    }

    public CharAssert describedAs(String description) {
        return this.as(description);
    }

    public CharAssert as(Description description) {
        this.description(description);
        return this;
    }

    public CharAssert describedAs(Description description) {
        return this.as(description);
    }

    public CharAssert isEqualTo(char expected) {
        if (this.actual == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(Character.valueOf(this.actual), Character.valueOf(expected)));
    }

    public CharAssert isNotEqualTo(char other) {
        if (this.actual != other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(Character.valueOf(this.actual), Character.valueOf(other)));
    }

    public CharAssert isGreaterThan(char other) {
        if (this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(Character.valueOf(this.actual), Character.valueOf(other)));
    }

    public CharAssert isLessThan(char other) {
        if (this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(Character.valueOf(this.actual), Character.valueOf(other)));
    }

    public CharAssert isGreaterThanOrEqualTo(char other) {
        if (this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(Character.valueOf(this.actual), Character.valueOf(other)));
    }

    public CharAssert isLessThanOrEqualTo(char other) {
        if (this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(Character.valueOf(this.actual), Character.valueOf(other)));
    }

    public CharAssert isUpperCase() {
        if (Character.isUpperCase(this.actual)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat(Formatting.inBrackets(Character.valueOf(this.actual)), " should be an uppercase character"));
    }

    public CharAssert isLowerCase() {
        if (Character.isLowerCase(this.actual)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat(Formatting.inBrackets(Character.valueOf(this.actual)), " should be a lowercase character"));
    }

    public CharAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

