/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.AbstractComponentMatcher;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeMatcher
extends AbstractComponentMatcher {
    private final Class<? extends Component> type;

    public TypeMatcher(Class<? extends Component> type) {
        this(type, false);
    }

    public TypeMatcher(Class<? extends Component> type, boolean requireShowing) {
        super(requireShowing);
        if (type == null) {
            throw new NullPointerException("The type of component to find should not be null");
        }
        this.type = type;
    }

    @Override
    @RunsInCurrentThread
    public boolean matches(Component c) {
        return this.type.isAssignableFrom(c.getClass()) && this.requireShowingMatches(c);
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[", "type=", this.type.getName(), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]");
    }
}

