/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.fest.assertions.Fail;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.core.ComponentFinder;
import org.fest.swing.core.ComponentMatcher;
import org.fest.swing.core.TypeMatcher;
import org.fest.swing.format.Formatting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UnexpectedJOptionPaneFinder {
    static final ComponentMatcher OPTION_PANE_MATCHER = new TypeMatcher(JOptionPane.class, true);
    private final ComponentFinder finder;

    UnexpectedJOptionPaneFinder(ComponentFinder finder) {
        this.finder = finder;
    }

    @RunsInEDT
    void requireNoJOptionPaneIsShowing() {
        List<Component> found = this.findAll(OPTION_PANE_MATCHER);
        if (!found.isEmpty()) {
            throw this.unexpectedJOptionPanesFound(found);
        }
    }

    private List<Component> findAll(ComponentMatcher m) {
        return new ArrayList<Component>(this.finder.findAll(m));
    }

    private AssertionError unexpectedJOptionPanesFound(List<Component> found) {
        StringBuilder message = new StringBuilder();
        message.append("Expecting no JOptionPane to be showing, but found:<[");
        int size = found.size();
        for (int i = 0; i < size; ++i) {
            message.append(Formatting.format(found.get(i)));
            if (i == size - 1) continue;
            message.append(", ");
        }
        message.append("]>");
        throw Fail.fail(message.toString());
    }
}

