/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.core.matcher;

import java.util.regex.Pattern;
import javax.swing.JLabel;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.core.matcher.NamedComponentMatcherTemplate;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JLabelMatcher
extends NamedComponentMatcherTemplate<JLabel> {
    private Object text;

    public static JLabelMatcher withName(String name) {
        return new JLabelMatcher(name, ANY);
    }

    public static JLabelMatcher withText(String text) {
        return new JLabelMatcher(ANY, (Object)text);
    }

    public static JLabelMatcher withText(Pattern textPattern) {
        return new JLabelMatcher(ANY, (Object)textPattern);
    }

    public static JLabelMatcher any() {
        return new JLabelMatcher(ANY, ANY);
    }

    private JLabelMatcher(Object name, Object text) {
        super(JLabel.class, name);
        this.text = text;
    }

    public JLabelMatcher andText(String newText) {
        this.text = newText;
        return this;
    }

    public JLabelMatcher andText(Pattern textPattern) {
        this.text = textPattern;
        return this;
    }

    public JLabelMatcher andShowing() {
        this.requireShowing(true);
        return this;
    }

    @Override
    @RunsInCurrentThread
    protected boolean isMatching(JLabel button) {
        if (!this.isNameMatching(button.getName())) {
            return false;
        }
        return this.arePropertyValuesMatching(this.text, button.getText());
    }

    public String toString() {
        return Strings.concat(this.getClass().getName(), "[", "name=", this.quotedName(), ", ", "text=", this.quoted(this.text), ", ", "requireShowing=", String.valueOf(this.requireShowing()), "]");
    }
}

