/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.fest.reflect.core.Reflection;

class ProtectingTimerTask
extends TimerTask {
    private static final int CANCELED = 3;
    private static Logger logger = Logger.getLogger(ProtectingTimerTask.class.getName());
    private final TimerTask task;

    ProtectingTimerTask(TimerTask task) {
        this.task = task;
    }

    public void run() {
        if (this.isCanceled()) {
            this.cancel();
            return;
        }
        try {
            this.task.run();
        }
        catch (Throwable thrown) {
            this.handleException(thrown);
        }
    }

    private boolean isCanceled() {
        boolean isCancelled = false;
        try {
            int state = Reflection.field("state").ofType(Integer.TYPE).in(this.task).get();
            isCancelled = state == 3;
        }
        catch (RuntimeException e) {
            this.handleException(e);
        }
        return isCancelled;
    }

    private void handleException(Throwable thrown) {
        logger.log(Level.WARNING, "Exception thrown by a TimerTask", thrown);
    }
}

