/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.fest.util.Objects;

public final class Strings {
    public static boolean isDefaultToString(String s) {
        if (org.fest.util.Strings.isEmpty(s)) {
            return false;
        }
        int at = s.indexOf("@");
        if (at == -1) {
            return false;
        }
        String hash = s.substring(at + 1, s.length());
        try {
            Integer.parseInt(hash, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean areEqualOrMatch(String pattern, String s) {
        if (Objects.areEqual(pattern, s)) {
            return true;
        }
        if (pattern != null && s != null) {
            try {
                return s.matches(pattern);
            }
            catch (PatternSyntaxException invalidRegex) {
                return s.contains(pattern);
            }
        }
        return false;
    }

    public static boolean match(Pattern p, String s) {
        return Strings.match(p, (CharSequence)s);
    }

    public static boolean match(Pattern p, CharSequence s) {
        if (p == null) {
            throw new NullPointerException("The pattern to match should not be null");
        }
        if (s == null) {
            return false;
        }
        return p.matcher(s).matches();
    }

    private Strings() {
    }
}

