/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser;

import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;
import javax.swing.BoundedRangeModel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.ColorSliderModel;
import org.pushingpixels.substance.internal.contrib.randelshofer.quaqua.colorchooser.RGBColorSliderModel;

public class ColorTrackImageProducer
extends MemoryImageSource {
    private int[] pixels;
    private int w;
    private int h;
    private float[] baseComponents;
    private int component;
    private int trackBuffer;
    private ColorSliderModel colorizer = new RGBColorSliderModel();
    private boolean isDirty = true;
    private int componentIndex = 0;
    private boolean isHorizontal;

    public ColorTrackImageProducer(int w, int h, int trackBuffer, boolean isHorizontal) {
        super(w, h, null, 0, w);
        this.pixels = new int[w * h];
        this.w = w;
        this.h = h;
        this.trackBuffer = trackBuffer % 2 == 1 ? trackBuffer - 1 : trackBuffer;
        this.componentIndex = this.componentIndex;
        this.isHorizontal = isHorizontal;
        this.newPixels(this.pixels, ColorModel.getRGBdefault(), 0, w);
        this.setAnimated(true);
    }

    public int getWidth() {
        return this.w;
    }

    public int getHeight() {
        return this.h;
    }

    public void markAsDirty() {
        this.isDirty = true;
    }

    public boolean needsGeneration() {
        return this.isDirty;
    }

    public void regenerateColorTrack() {
        if (this.isDirty) {
            this.generateColorTrack();
        }
    }

    public void generateColorTrack() {
        if (this.isHorizontal) {
            this.generateHorizontalColorTrack();
        } else {
            this.generateVerticalColorTrack();
        }
        this.newPixels();
        this.isDirty = false;
    }

    private void generateHorizontalColorTrack() {
        int offset = this.trackBuffer / 2;
        int x = 0;
        int n = this.w - this.trackBuffer - 1;
        while (x <= n) {
            this.pixels[x + offset] = this.colorizer.getInterpolatedRGB(this.componentIndex, (float)x / (float)n);
            ++x;
        }
        x = 0;
        while (x < offset) {
            this.pixels[x] = this.pixels[offset];
            this.pixels[this.w - x - 1] = this.pixels[this.w - offset - 1];
            ++x;
        }
        int y = this.w;
        n = this.w * this.h;
        while (y < n) {
            System.arraycopy(this.pixels, 0, this.pixels, y, this.w);
            y += this.w;
        }
    }

    private void generateVerticalColorTrack() {
        int offset = this.trackBuffer / 2;
        int y = 0;
        int n = this.h - this.trackBuffer - 1;
        while (y <= n) {
            this.pixels[(y + offset) * this.w] = this.colorizer.getInterpolatedRGB(this.componentIndex, 1.0f - (float)y / (float)n);
            ++y;
        }
        y = 0;
        while (y < offset) {
            this.pixels[y * this.w] = this.pixels[offset * this.w];
            this.pixels[(this.h - y - 1) * this.w] = this.pixels[(this.h - offset - 1) * this.w];
            ++y;
        }
        int x = 1;
        while (x < this.w) {
            int y2 = 0;
            int n2 = this.w * this.h;
            while (y2 < n2) {
                this.pixels[x + y2] = this.pixels[x - 1 + y2];
                y2 += this.w;
            }
            ++x;
        }
    }

    public void setBaseComponents(BoundedRangeModel[] components) {
        this.isDirty = true;
        int i = 0;
        while (i < components.length) {
            this.baseComponents[i] = (float)components[i].getValue() / (float)components[i].getMaximum();
            ++i;
        }
    }

    public void setColorSliderModel(ColorSliderModel colorizer) {
        this.colorizer = colorizer;
        this.isDirty = true;
    }

    public void setColorComponentIndex(int index) {
        this.componentIndex = index;
        this.isDirty = true;
    }

    public void componentChanged(int index) {
        this.isDirty |= this.componentIndex != index;
    }
}

